/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.redmine.RedmineProjectProperty;
import hudson.plugins.redmine.RedmineRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineRepositoryBrowser
extends SubversionRepositoryBrowser {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RedmineRepositoryBrowser() {
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        URL baseUrl = this.getRedmineURL(path.getLogEntry());
        String projectName = this.getProject(path.getLogEntry());
        String filePath = this.getFilePath(path.getLogEntry(), path.getValue());
        int revision = path.getLogEntry().getRevision();
        return new URL(baseUrl, "repositories/diff/" + projectName + filePath + "?rev=" + revision);
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        URL baseUrl = this.getRedmineURL(path.getLogEntry());
        String projectName = this.getProject(path.getLogEntry());
        String filePath = this.getFilePath(path.getLogEntry(), path.getValue());
        return baseUrl == null ? null : new URL(baseUrl, "repositories/entry/" + projectName + filePath);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        URL baseUrl = this.getRedmineURL(changeSet);
        String projectName = this.getProject(changeSet);
        return baseUrl == null ? null : new URL(baseUrl, "repositories/revision/" + projectName + "/" + changeSet.getRevision());
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return DESCRIPTOR;
    }

    private URL getRedmineURL(SubversionChangeLogSet.LogEntry logEntry) throws MalformedURLException {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        if (rpp == null) {
            return null;
        }
        return new URL(rpp.redmineWebsite);
    }

    private String getProject(SubversionChangeLogSet.LogEntry logEntry) {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        if (rpp == null) {
            return null;
        }
        return rpp.projectName;
    }

    private String getFilePath(SubversionChangeLogSet.LogEntry logEntry, String fileFullPath) {
        AbstractProject p = logEntry.getParent().build.getProject();
        RedmineProjectProperty rpp = (RedmineProjectProperty)p.getProperty(RedmineProjectProperty.class);
        String filePath = "";
        if (rpp.redmineVersion.booleanValue()) {
            filePath = fileFullPath;
        } else {
            String[] filePaths = fileFullPath.split("/");
            filePath = "/";
            if (filePaths.length > 2) {
                for (int i = 2; i < filePaths.length; ++i) {
                    filePath = filePath + filePaths[i];
                    if (i == filePaths.length - 1) continue;
                    filePath = filePath + "/";
                }
            }
        }
        return filePath;
    }
}

