/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.release.ReleaseWrapper;
import hudson.plugins.release.WrappedBuild;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseWrapper
extends BuildWrapper {
    private List<Builder> preBuildSteps = new ArrayList();
    private List<Builder> postBuildSteps = new ArrayList();
    private transient boolean releaseBuild = false;
    private transient String releaseVersion;
    private transient String developmentVersion;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postSuccessBuildSteps) {
        this.postBuildSteps = postSuccessBuildSteps;
    }

    public Action getProjectAction(AbstractProject job) {
        return new ReleaseAction(this, job);
    }

    private void enableReleaseBuild() {
        this.releaseBuild = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ReleaseWrapper releaseWrapper = this;
        synchronized (releaseWrapper) {
            if (!this.releaseBuild) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            this.releaseBuild = false;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("RELEASE_VERSION", this.releaseVersion);
        properties.put("DEVELOPMENT_VERSION", this.developmentVersion);
        build.addAction((Action)new ReleaseBuildBadgeAction(this.releaseVersion));
        WrappedBuild wrappedBuild = new WrappedBuild(build, properties);
        if (!this.executeBuildSteps(this.preBuildSteps, (AbstractBuild)wrappedBuild, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.prebuild(build, listener);
        }
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.perform(build, launcher, listener);
        }
        return shouldContinue;
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ String access$000(ReleaseWrapper x0) {
        return x0.releaseVersion;
    }

    static /* synthetic */ List access$100(ReleaseWrapper x0) {
        return x0.postBuildSteps;
    }

    static /* synthetic */ boolean access$200(ReleaseWrapper x0, List x1, AbstractBuild x2, Launcher x3, BuildListener x4) throws InterruptedException, IOException {
        return x0.executeBuildSteps(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$302(ReleaseWrapper x0, List x1) {
        x0.preBuildSteps = x1;
        return x0.preBuildSteps;
    }

    static /* synthetic */ List access$102(ReleaseWrapper x0, List x1) {
        x0.postBuildSteps = x1;
        return x0.postBuildSteps;
    }

    static /* synthetic */ void access$400(ReleaseWrapper x0) {
        x0.enableReleaseBuild();
    }

    static /* synthetic */ String access$002(ReleaseWrapper x0, String x1) {
        x0.releaseVersion = x1;
        return x0.releaseVersion;
    }

    static /* synthetic */ String access$502(ReleaseWrapper x0, String x1) {
        x0.developmentVersion = x1;
        return x0.developmentVersion;
    }
}

