/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.BallColor;
import hudson.model.BuildBadgeAction;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.search.Search;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedBuild<P extends AbstractProject<P, R>, R extends AbstractBuild<P, R>>
extends AbstractBuild<P, R> {
    private AbstractBuild<P, R> build;
    private Map<String, String> variables;

    public WrappedBuild(AbstractBuild<P, R> build, Map<String, String> variables) throws IOException {
        super(build.getProject(), build.getTimestamp());
        this.build = build;
        this.variables = variables;
    }

    public void addAction(Action a) {
        this.build.addAction(a);
    }

    public void checkPermission(Permission p) {
        this.build.checkPermission(p);
    }

    public int compareTo(R that) {
        return this.build.compareTo(that);
    }

    public void delete() throws IOException {
        this.build.delete();
    }

    public void doArtifact(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.build.doArtifact(req, rsp);
    }

    public void doBuildNumber(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.build.doBuildNumber(req, rsp);
    }

    public void doBuildStatus(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.build.doBuildStatus(req, rsp);
    }

    public void doBuildTimestamp(StaplerRequest req, StaplerResponse rsp, String format) throws IOException {
        this.build.doBuildTimestamp(req, rsp, format);
    }

    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.build.doDoDelete(req, rsp);
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.build.doProgressiveLog(req, rsp);
    }

    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.build.doStop(req, rsp);
    }

    public void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.build.doSubmitDescription(req, rsp);
    }

    public void doToggleLogKeep(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.build.doToggleLogKeep(req, rsp);
    }

    public Calendar due() {
        return this.build.due();
    }

    public boolean equals(Object obj) {
        return this.build.equals(obj);
    }

    public ACL getACL() {
        return this.build.getACL();
    }

    public <T extends Action> T getAction(Class<T> type) {
        return (T)this.build.getAction(type);
    }

    public Action getAction(int index) {
        return this.build.getAction(index);
    }

    public List<Action> getActions() {
        return this.build.getActions();
    }

    public <T extends Action> List<T> getActions(Class<T> type) {
        return this.build.getActions(type);
    }

    public Api getApi(StaplerRequest req) {
        return this.build.getApi(req);
    }

    public List<Run.Artifact> getArtifacts() {
        return this.build.getArtifacts();
    }

    public File getArtifactsDir() {
        return this.build.getArtifactsDir();
    }

    public List<BuildBadgeAction> getBadgeActions() {
        return this.build.getBadgeActions();
    }

    public Run.Summary getBuildStatusSummary() {
        return this.build.getBuildStatusSummary();
    }

    public String getBuildStatusUrl() {
        return this.build.getBuildStatusUrl();
    }

    public Map<String, String> getBuildVariables() {
        return this.build.getBuildVariables();
    }

    public Node getBuiltOn() {
        return this.build.getBuiltOn();
    }

    public String getBuiltOnStr() {
        return this.build.getBuiltOnStr();
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return this.build.getChangeSet();
    }

    public Set<User> getCulprits() {
        return this.build.getCulprits();
    }

    public Map<AbstractProject, AbstractBuild.DependencyChange> getDependencyChanges(AbstractBuild from) {
        return this.build.getDependencyChanges(from);
    }

    public String getDescription() {
        return this.build.getDescription();
    }

    public String getDisplayName() {
        return this.build.getDisplayName();
    }

    public Map<AbstractProject, Fingerprint.RangeSet> getDownstreamBuilds() {
        return this.build.getDownstreamBuilds();
    }

    public Iterable<AbstractBuild<?, ?>> getDownstreamBuilds(AbstractProject<?, ?> that) {
        return this.build.getDownstreamBuilds(that);
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        return this.build.getDownstreamRelationship(that);
    }

    public long getDuration() {
        return this.build.getDuration();
    }

    public String getDurationString() {
        return this.build.getDurationString();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.build.getDynamic(token, req, rsp);
    }

    public Map<String, String> getEnvVars() {
        Map envVars = this.build.getEnvVars();
        envVars.putAll(this.variables);
        return envVars;
    }

    public Executor getExecutor() {
        return this.build.getExecutor();
    }

    public boolean getHasArtifacts() {
        return this.build.getHasArtifacts();
    }

    public BallColor getIconColor() {
        return this.build.getIconColor();
    }

    public String getId() {
        return this.build.getId();
    }

    public String getLog() throws IOException {
        return this.build.getLog();
    }

    public List<String> getLog(int maxLines) throws IOException {
        return this.build.getLog(maxLines);
    }

    public File getLogFile() {
        return this.build.getLogFile();
    }

    public R getNextBuild() {
        return (R)((AbstractBuild)this.build.getNextBuild());
    }

    public int getNumber() {
        return this.build.getNumber();
    }

    public P getParent() {
        return (P)((AbstractProject)this.build.getParent());
    }

    public R getPreviousBuild() {
        return (R)((AbstractBuild)this.build.getPreviousBuild());
    }

    public R getPreviousFailedBuild() {
        return (R)((AbstractBuild)this.build.getPreviousFailedBuild());
    }

    public R getPreviousNotFailedBuild() {
        return (R)((AbstractBuild)this.build.getPreviousNotFailedBuild());
    }

    public Result getResult() {
        return this.build.getResult();
    }

    public File getRootDir() {
        return this.build.getRootDir();
    }

    public Search getSearch() {
        return this.build.getSearch();
    }

    public String getSearchName() {
        return this.build.getSearchName();
    }

    public AbstractTestResultAction getTestResultAction() {
        return this.build.getTestResultAction();
    }

    public Calendar getTimestamp() {
        return this.build.getTimestamp();
    }

    public String getTimestampString() {
        return this.build.getTimestampString();
    }

    public String getTimestampString2() {
        return this.build.getTimestampString2();
    }

    public Map<AbstractProject, Integer> getTransitiveUpstreamBuilds() {
        return this.build.getTransitiveUpstreamBuilds();
    }

    public String getTruncatedDescription() {
        return this.build.getTruncatedDescription();
    }

    public Map<AbstractProject, Integer> getUpstreamBuilds() {
        return this.build.getUpstreamBuilds();
    }

    public int getUpstreamRelationship(AbstractProject that) {
        return this.build.getUpstreamRelationship(that);
    }

    public AbstractBuild<?, ?> getUpstreamRelationshipBuild(AbstractProject<?, ?> that) {
        return this.build.getUpstreamRelationshipBuild(that);
    }

    public String getUpUrl() {
        return this.build.getUpUrl();
    }

    public String getUrl() {
        return this.build.getUrl();
    }

    public String getWhyKeepLog() {
        return this.build.getWhyKeepLog();
    }

    public boolean hasChangeSetComputed() {
        return this.build.hasChangeSetComputed();
    }

    public int hashCode() {
        return this.build.hashCode();
    }

    public boolean hasntStartedYet() {
        return this.build.hasntStartedYet();
    }

    public boolean hasParticipant(User user) {
        return this.build.hasParticipant(user);
    }

    public boolean hasPermission(Permission p) {
        return this.build.hasPermission(p);
    }

    public boolean isBuilding() {
        return this.build.isBuilding();
    }

    public boolean isLogUpdated() {
        return this.build.isLogUpdated();
    }

    public void keepLog(boolean newValue) throws IOException {
        this.build.keepLog(newValue);
    }

    public void run() {
        this.build.run();
    }

    public void save() throws IOException {
        this.build.save();
    }

    public void setDescription(String description) throws IOException {
        this.build.setDescription(description);
    }

    public void setResult(Result r) {
        this.build.setResult(r);
    }

    public String toString() {
        return "WrappedBuild: " + this.build.toString();
    }
}

