/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.plugins.release.WrappedBuild;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseWrapper
extends BuildWrapper {
    private List<Builder> preBuildSteps = new ArrayList<Builder>();
    private List<Builder> postBuildSteps = new ArrayList<Builder>();
    private transient boolean releaseBuild = false;
    private transient String releaseVersion;
    private transient String developmentVersion;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postSuccessBuildSteps) {
        this.postBuildSteps = postSuccessBuildSteps;
    }

    public Action getProjectAction(AbstractProject job) {
        return new ReleaseAction(job);
    }

    private void enableReleaseBuild() {
        this.releaseBuild = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ReleaseWrapper releaseWrapper = this;
        synchronized (releaseWrapper) {
            if (!this.releaseBuild) {
                return new BuildWrapper.Environment(){};
            }
            this.releaseBuild = false;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("RELEASE_VERSION", this.releaseVersion);
        properties.put("DEVELOPMENT_VERSION", this.developmentVersion);
        build.addAction((Action)new ReleaseBuildBadgeAction(this.releaseVersion));
        final WrappedBuild wrappedBuild = new WrappedBuild(build, properties);
        if (!this.executeBuildSteps(this.preBuildSteps, wrappedBuild, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                build.keepLog();
                build.setDescription("Release # " + ReleaseWrapper.this.releaseVersion);
                return ReleaseWrapper.this.executeBuildSteps(ReleaseWrapper.this.postBuildSteps, wrappedBuild, launcher, listener);
            }
        };
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.prebuild(build, listener);
        }
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.perform(build, launcher, listener);
        }
        return shouldContinue;
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class ReleaseBuildBadgeAction
    implements BuildBadgeAction {
        private String releaseVersion;

        public ReleaseBuildBadgeAction(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReleaseAction
    implements Action {
        private AbstractProject project;
        private String releaseVersion;
        private String developmentVersion;

        public ReleaseAction(AbstractProject project) {
            this.project = project;
        }

        public String getDisplayName() {
            return "Release";
        }

        public String getIconFileName() {
            return "package.gif";
        }

        public String getUrlName() {
            return "release";
        }

        public AbstractProject getProject() {
            return this.project;
        }

        public List<String> getPreviousReleaseVersions() {
            LinkedList<String> previousReleaseVersions = new LinkedList<String>();
            for (AbstractBuild build : this.project.getBuilds()) {
                ReleaseBuildBadgeAction badge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
                if (badge == null) continue;
                previousReleaseVersions.add(badge.getReleaseVersion());
            }
            return previousReleaseVersions;
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public String getDevelopmentVersion() {
            return this.developmentVersion;
        }

        public void setDevelopmentVersion(String developmentVersion) {
            this.developmentVersion = developmentVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException {
            req.bindParameters((Object)this);
            ReleaseWrapper releaseWrapper = ReleaseWrapper.this;
            synchronized (releaseWrapper) {
                if (Hudson.getInstance().getQueue().add(this.project, 0)) {
                    ReleaseWrapper.this.enableReleaseBuild();
                    ReleaseWrapper.this.releaseVersion = this.releaseVersion;
                    ReleaseWrapper.this.developmentVersion = this.developmentVersion;
                    this.releaseVersion = null;
                    this.developmentVersion = null;
                }
            }
            resp.sendRedirect(this.project.getAbsoluteUrl());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(ReleaseWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "Configure release build";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ReleaseWrapper instance = new ReleaseWrapper();
            instance.preBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preBuildSteps", (Collection)BuildStep.BUILDERS);
            instance.postBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postBuildSteps", (Collection)BuildStep.BUILDERS);
            return instance;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return FreeStyleProject.class.isInstance(item) || MavenModuleSet.class.isInstance(item);
        }
    }
}

