/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release.dashboard;

import hudson.FeedAdapter;
import hudson.model.Job;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.plugins.release.ReleaseWrapper;
import hudson.plugins.release.dashboard.RecentReleasesPortlet;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.RunList;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentReleasesPortlet
extends DashboardPortlet {
    @DataBoundConstructor
    public RecentReleasesPortlet(String name) {
        super(name);
    }

    public Collection<Run> getRecentReleases(int max) {
        LinkedList<Run> recentReleases = new LinkedList<Run>();
        for (Job job : this.getDashboard().getJobs()) {
            ReleaseWrapper.ReleaseBuildBadgeAction rbb;
            for (Run run = job.getLastCompletedBuild(); !(run == null || recentReleases.size() >= max && run.getTimestamp().compareTo(recentReleases.getLast().getTimestamp()) <= 0 || (rbb = (ReleaseWrapper.ReleaseBuildBadgeAction)run.getAction(ReleaseWrapper.ReleaseBuildBadgeAction.class)) != null && !this.insertRun(run, recentReleases, max)); run = run.getPreviousBuild()) {
            }
        }
        return recentReleases;
    }

    public String getReleaseVersion(Run run) {
        ReleaseWrapper.ReleaseBuildBadgeAction rbb = (ReleaseWrapper.ReleaseBuildBadgeAction)run.getAction(ReleaseWrapper.ReleaseBuildBadgeAction.class);
        return rbb.getReleaseVersion();
    }

    private boolean insertRun(Run run, LinkedList<Run> recentReleases, int max) {
        ListIterator<Run> iter = recentReleases.listIterator();
        Run recentRun = null;
        do {
            if (((recentRun = iter.hasNext() ? (Run)iter.next() : null) != null || recentReleases.size() >= max) && (recentRun == null || run.getTimestamp().compareTo(recentRun.getTimestamp()) <= 0)) continue;
            if (!recentReleases.isEmpty() && recentRun != null) {
                iter.previous();
            }
            iter.add(run);
            if (recentReleases.size() > max) {
                recentReleases.removeLast();
            }
            return true;
        } while (recentRun != null);
        return false;
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", RunList.fromRuns((Collection)this.getRecentReleases(20)));
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " failed builds", RunList.fromRuns((Collection)this.getRecentReleases(20)).failureOnly());
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs) throws IOException, ServletException {
        RSS.forwardToRss((String)(this.getDisplayName() + suffix), (String)(this.getDashboard().getUrl() + this.getUrl()), (Collection)runs.newBuilds(), (FeedAdapter)new RelativePathFeedAdapter(this, this.getDashboard().getUrl() + this.getUrl()), (StaplerRequest)req, (HttpServletResponse)rsp);
    }
}

