/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseWrapper
extends BuildWrapper {
    private static final String DEFAULT_RELEASE_VERSION_TEMPLATE = "Release #$RELEASE_VERSION";
    private String releaseVersionTemplate;
    private boolean doNotKeepLog;
    private List<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
    private List<Builder> preBuildSteps = new ArrayList<Builder>();
    private List<Builder> postBuildSteps = new ArrayList<Builder>();

    public String getReleaseVersionTemplate() {
        return this.releaseVersionTemplate;
    }

    public void setReleaseVersionTemplate(String releaseVersionTemplate) {
        this.releaseVersionTemplate = releaseVersionTemplate;
    }

    public boolean isDoNotKeepLog() {
        return this.doNotKeepLog;
    }

    public void setDoNotKeepLog(boolean doNotKeepLog) {
        this.doNotKeepLog = doNotKeepLog;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions;
    }

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postSuccessBuildSteps) {
        this.postBuildSteps = postSuccessBuildSteps;
    }

    public Action getProjectAction(AbstractProject job) {
        return new ReleaseAction(job);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final ReleaseBuildBadgeAction releaseBuildBadge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
        if (releaseBuildBadge == null) {
            return new BuildWrapper.Environment(){};
        }
        ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parametersAction != null) {
            VariableResolver<String> resolver;
            String releaseVersion = Util.replaceMacro((String)(this.releaseVersionTemplate != null && !"".equals(this.releaseVersionTemplate) ? this.releaseVersionTemplate : DEFAULT_RELEASE_VERSION_TEMPLATE), resolver = this.createVariableResolver(parametersAction, build));
            if (DEFAULT_RELEASE_VERSION_TEMPLATE.equals(releaseVersion)) {
                releaseVersion = null;
            }
            releaseBuildBadge.releaseVersion = releaseVersion;
        }
        if (!this.executeBuildSteps(this.preBuildSteps, build, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (!ReleaseWrapper.this.doNotKeepLog) {
                    build.keepLog();
                }
                if (releaseBuildBadge.getReleaseVersion() != null) {
                    build.setDescription(releaseBuildBadge.getReleaseVersion());
                }
                return ReleaseWrapper.this.executeBuildSteps(ReleaseWrapper.this.postBuildSteps, build, launcher, listener);
            }
        };
    }

    private VariableResolver<String> createVariableResolver(ParametersAction parametersAction, AbstractBuild<?, ?> build) {
        Object[] resolvers = new VariableResolver[parametersAction.getParameters().size() + 1];
        int i = 0;
        for (ParameterValue p : parametersAction.getParameters()) {
            resolvers[i++] = p.createVariableResolver(build);
        }
        resolvers[i] = build.getBuildVariableResolver();
        ArrayUtils.reverse((Object[])resolvers);
        return new VariableResolver.Union((VariableResolver[])resolvers);
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        if (buildSteps != null) {
            for (Builder buildStep : buildSteps) {
                if (!shouldContinue) break;
                shouldContinue = buildStep.prebuild(build, listener);
            }
            for (Builder buildStep : buildSteps) {
                if (!shouldContinue) break;
                shouldContinue = buildStep.perform(build, launcher, listener);
            }
        }
        return shouldContinue;
    }

    public static boolean hasReleasePermission(AbstractProject job) {
        return job.hasPermission(Item.BUILD);
    }

    public static void checkReleasePermission(AbstractProject job) {
        job.checkPermission(Item.BUILD);
    }

    public static class ReleaseBuildBadgeAction
    implements BuildBadgeAction {
        private String releaseVersion;

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReleaseAction
    implements Action {
        private AbstractProject project;
        private String releaseVersion;
        private String developmentVersion;

        public ReleaseAction(AbstractProject project) {
            this.project = project;
        }

        public List<ParameterDefinition> getParameterDefinitions() {
            return ReleaseWrapper.this.parameterDefinitions;
        }

        public String getDisplayName() {
            return "Release";
        }

        public String getIconFileName() {
            return ReleaseWrapper.hasReleasePermission(this.project) ? "package.gif" : null;
        }

        public String getUrlName() {
            return "release";
        }

        public AbstractProject getProject() {
            return this.project;
        }

        public List<String> getPreviousReleaseVersions() {
            LinkedList<String> previousReleaseVersions = new LinkedList<String>();
            for (AbstractBuild build : this.project.getBuilds()) {
                ReleaseBuildBadgeAction badge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
                if (badge == null || badge.getReleaseVersion() == null) continue;
                previousReleaseVersions.add(badge.getReleaseVersion());
            }
            return previousReleaseVersions;
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public String getDevelopmentVersion() {
            return this.developmentVersion;
        }

        public void setDevelopmentVersion(String developmentVersion) {
            this.developmentVersion = developmentVersion;
        }

        public ParameterDefinition getParameterDefinition(String name) {
            if (ReleaseWrapper.this.parameterDefinitions == null) {
                return null;
            }
            for (ParameterDefinition pd : ReleaseWrapper.this.parameterDefinitions) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
            return null;
        }

        private List<ParameterValue> getDefaultParametersValues() {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
            if (paramDefProp == null) {
                return defValues;
            }
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }

        public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
            ReleaseWrapper.checkReleasePermission(this.project);
            req.bindParameters((Object)this);
            List<ParameterValue> paramValues = this.getDefaultParametersValues();
            if (this.getParameterDefinitions() != null && !this.getParameterDefinitions().isEmpty()) {
                JSONObject formData = req.getSubmittedForm();
                JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
                for (Object o : a) {
                    JSONObject jo = (JSONObject)o;
                    String name = jo.getString("name");
                    ParameterDefinition d = this.getParameterDefinition(name);
                    if (d == null) {
                        throw new IllegalArgumentException("No such parameter definition: " + name);
                    }
                    ParameterValue value = d.createValue(req, jo);
                    paramValues.add(d.createValue(req, jo));
                }
            } else {
                if (this.releaseVersion != null && !"".equals(this.releaseVersion)) {
                    paramValues.add((ParameterValue)new StringParameterValue("RELEASE_VERSION", this.releaseVersion));
                }
                if (this.developmentVersion != null && !"".equals(this.developmentVersion)) {
                    paramValues.add((ParameterValue)new StringParameterValue("DEVELOPMENT_VERSION", this.developmentVersion));
                }
            }
            if (!this.project.scheduleBuild(0, (Cause)new Cause.UserCause(), new Action[]{new ReleaseBuildBadgeAction(), new ParametersAction(paramValues)})) {
                // empty if block
            }
            resp.sendRedirect(this.project.getAbsoluteUrl());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Configure release build";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ReleaseWrapper instance = new ReleaseWrapper();
            instance.releaseVersionTemplate = formData.getString("releaseVersionTemplate");
            instance.doNotKeepLog = formData.getBoolean("doNotKeepLog");
            instance.parameterDefinitions = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"parameters", (Collection)ParameterDefinition.all());
            instance.preBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preBuildSteps", (Collection)Builder.all());
            instance.postBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postBuildSteps", (Collection)Builder.all());
            return instance;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return FreeStyleProject.class.isInstance(item) || MavenModuleSet.class.isInstance(item);
        }
    }
}

