/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.release.ReleaseStringParameterValue;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ReleaseStringParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ReleaseStringParameterDefinition(String name, String description) {
        super(name, description);
    }

    public ParameterValue getDefaultParameterValue() {
        ReleaseStringParameterValue v = new ReleaseStringParameterValue(this.getName(), "", this.getDescription());
        return v;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        ReleaseStringParameterValue value = (ReleaseStringParameterValue)req.bindJSON(ReleaseStringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Illegal number of parameter values for " + this.getName() + ": " + value.length);
        }
        return new ReleaseStringParameterValue(this.getName(), value[0], this.getDescription());
    }
}

