/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.plugins.release.ReleaseVersionValue;
import hudson.util.VariableResolver;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseStringParameterValue
extends ParameterValue
implements ReleaseVersionValue {
    private static final long serialVersionUID = 1L;
    @Exported(visibility=4)
    public final String value;

    @DataBoundConstructor
    public ReleaseStringParameterValue(String name, String value) {
        this(name, value, null);
    }

    public ReleaseStringParameterValue(String name, String value, String description) {
        super(name, description);
        this.value = value;
    }

    @Override
    public String getReleaseVersion() {
        return this.value;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        env.put(this.name.toUpperCase(), this.value);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return ReleaseStringParameterValue.this.name.equals(name) ? ReleaseStringParameterValue.this.value : null;
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseStringParameterValue other = (ReleaseStringParameterValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(ReleaseStringParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

