/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.plugins.robot.AbstractRobotAction;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.helper.NumberHelper;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotResultStatistics;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotBuildAction
extends AbstractRobotAction {
    private static final String GRAPH_YLABEL = "Number of testcases";
    private static final String GRAPH_XLABEL = "Build number";
    private AbstractBuild<?, ?> build;
    private RobotResult result;
    private String reportFileName;
    private String outputPath;

    public RobotBuildAction(AbstractBuild<?, ?> build, RobotResult result, String outputPath, String reportFileName) {
        this.build = build;
        this.result = result;
        this.outputPath = outputPath;
        this.reportFileName = reportFileName;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public double getPassPercentage() {
        double percentage = (double)((RobotResultStatistics)this.result.getOverallStats().get(1)).getPass() / (double)((RobotResultStatistics)this.result.getOverallStats().get(1)).getTotal() * 100.0;
        return NumberHelper.roundToDecimals((double)percentage, (int)1);
    }

    public double getCriticalPassPercentage() {
        double percentage = (double)((RobotResultStatistics)this.result.getOverallStats().get(0)).getPass() / (double)((RobotResultStatistics)this.result.getOverallStats().get(0)).getTotal() * 100.0;
        return NumberHelper.roundToDecimals((double)percentage, (int)1);
    }

    public long getAllPassed() {
        return ((RobotResultStatistics)this.result.getOverallStats().get(1)).getPass();
    }

    public long getAllFailed() {
        return ((RobotResultStatistics)this.result.getOverallStats().get(1)).getFail();
    }

    public long getAllTotal() {
        return this.getAllPassed() + this.getAllFailed();
    }

    public long getCriticalFailed() {
        return ((RobotResultStatistics)this.result.getOverallStats().get(0)).getFail();
    }

    public long getCriticalPassed() {
        return ((RobotResultStatistics)this.result.getOverallStats().get(0)).getPass();
    }

    public long getCriticalTotal() {
        return this.getCriticalPassed() + this.getCriticalFailed();
    }

    public List<RobotResultStatistics> getOverallStats() {
        return this.result.getOverallStats();
    }

    public RobotResult getResult() {
        return this.result;
    }

    public void setResult(RobotResult result) {
        this.result = result;
    }

    public void setBuild(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public String getReportFileName() {
        return StringUtils.isBlank((String)this.reportFileName) ? "report.html" : this.reportFileName;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        RobotGraph g = new RobotGraph(this.getBuild(), this.getDataSet(), GRAPH_YLABEL, GRAPH_XLABEL, 500, 200);
        g.doPng(req, rsp);
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String indexFile = this.getReportFileName();
        FilePath robotDir = this.getRobotDir();
        if (!new FilePath(robotDir, indexFile).exists()) {
            rsp.sendRedirect2("notfound");
            return;
        }
        DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, this.getRobotDir(), this.getDisplayName(), "folder.gif", false);
        dbs.setIndexFileName(indexFile);
        dbs.generateResponse(req, rsp, (Object)this);
    }

    private CategoryDataset getDataSet() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        ArrayList<String> rows = new ArrayList<String>();
        ArrayList<ChartUtil.NumberOnlyBuildLabel> columns = new ArrayList<ChartUtil.NumberOnlyBuildLabel>();
        for (AbstractBuild build = this.build; build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            RobotBuildAction action = (RobotBuildAction)build.getAction(this.getClass());
            Number failed = 0;
            Number passed = 0;
            if (action != null) {
                failed = action.getAllFailed();
                passed = action.getAllPassed();
            }
            if (failed < 1) {
                failed = Float.valueOf(0.01f);
            }
            if (passed < 1) {
                passed = Float.valueOf(0.01f);
            }
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            values.add((Integer)passed);
            rows.add("Passed");
            columns.add(label);
            values.add((Integer)failed);
            rows.add("Failed");
            columns.add(label);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        TreeSet rowSet = new TreeSet(rows);
        TreeSet colSet = new TreeSet(columns);
        Comparable[] _rows = rowSet.toArray(new Comparable[rowSet.size()]);
        Comparable[] _cols = colSet.toArray(new Comparable[colSet.size()]);
        for (int i = _rows.length - 1; i >= 0; --i) {
            dataset.setValue(null, _rows[i], _cols[0]);
        }
        for (Comparable c : _cols) {
            dataset.setValue(null, _rows[0], c);
        }
        for (int i = 0; i < values.size(); ++i) {
            dataset.addValue((Number)values.get(i), (Comparable)rows.get(i), (Comparable)columns.get(i));
        }
        return dataset;
    }

    protected FilePath getRobotDir() {
        FilePath rootDir = new FilePath(this.build.getRootDir());
        if (StringUtils.isNotBlank((String)this.outputPath)) {
            return new FilePath(rootDir, this.outputPath);
        }
        return rootDir;
    }
}

