/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotProjectAction;
import hudson.plugins.robot.helper.NumberHelper;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.parser.RobotParser;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotPublisher
extends Recorder {
    public static final String DEFAULT_REPORT_FILE = "report.html";
    public static final String FILE_ARCHIVE_DIR = "robot-plugin";
    private static final String DEFAULT_OUTPUT_FILE = "output.xml";
    private static final String DEFAULT_LOG_FILE = "log.html";
    private String outputPath;
    private String reportFileName;
    private String logFileName;
    private String outputFileName;
    private double passThreshold;
    private double unstableThreshold;
    private boolean onlyCritical;

    @DataBoundConstructor
    public RobotPublisher(String outputPath, String outputFileName, String reportFileName, String logFileName, double passThreshold, double unstableThreshold, boolean onlyCritical) {
        this.outputPath = outputPath;
        this.outputFileName = outputFileName;
        this.reportFileName = reportFileName;
        this.passThreshold = passThreshold;
        this.unstableThreshold = unstableThreshold;
        this.logFileName = logFileName;
        this.onlyCritical = onlyCritical;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOutputFileName() {
        if (StringUtils.isBlank((String)this.outputFileName)) {
            return DEFAULT_OUTPUT_FILE;
        }
        return this.outputFileName;
    }

    public String getReportFileName() {
        if (StringUtils.isBlank((String)this.reportFileName)) {
            return DEFAULT_REPORT_FILE;
        }
        return this.reportFileName;
    }

    public String getLogFileName() {
        if (StringUtils.isBlank((String)this.logFileName)) {
            return DEFAULT_LOG_FILE;
        }
        return this.logFileName;
    }

    public double getPassThreshold() {
        return this.forceValidValue(this.passThreshold);
    }

    public double getUnstableThreshold() {
        return this.forceValidValue(this.unstableThreshold);
    }

    public boolean getOnlyCritical() {
        return this.onlyCritical;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new RobotProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (build.getResult() != Result.ABORTED) {
            double passPercentage;
            RobotResult result;
            PrintStream logger = listener.getLogger();
            logger.println("Robot results publisher started...");
            FilePath robotOutputDir = new FilePath(build.getWorkspace(), this.outputPath);
            RobotParser parser = new RobotParser(new FilePath(robotOutputDir, this.getOutputFileName()));
            logger.println("-Parsing output xml:");
            try {
                result = (RobotResult)robotOutputDir.act((FilePath.FileCallable)parser);
                logger.println(" Done!");
                logger.println("-Copying log files to build dir:");
                this.copyRobotFilesToBuildDir(build);
                logger.println(" Done!");
            }
            catch (Exception e) {
                logger.println(" Failed!");
                e.getCause().printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return true;
            }
            logger.println("-Assigning results to build:");
            RobotBuildAction action = new RobotBuildAction(build, result, FILE_ARCHIVE_DIR, this.getReportFileName());
            build.addAction((Action)action);
            logger.println(" Done!");
            logger.println("-Checking thresholds:");
            double d = passPercentage = this.onlyCritical ? action.getCriticalPassPercentage() : action.getPassPercentage();
            if (build.getResult() != Result.FAILURE) {
                if (passPercentage < this.getUnstableThreshold()) {
                    logger.println(" Pass ratio under unstable threshold of " + this.getUnstableThreshold() + "%, marking build failed");
                    build.setResult(Result.FAILURE);
                } else if (passPercentage < this.getPassThreshold()) {
                    logger.println(" Pass ratio under pass threshold of " + this.getPassThreshold() + "%, marking build unstable");
                    build.setResult(Result.UNSTABLE);
                }
            }
            logger.println(" Done!");
            logger.println("Done publishing Robot results.");
        }
        return true;
    }

    private void copyRobotFilesToBuildDir(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath srcDir = new FilePath(build.getWorkspace(), this.outputPath);
        FilePath destDir = new FilePath(new FilePath(build.getRootDir()), FILE_ARCHIVE_DIR);
        this.copySplittedFiles(srcDir, destDir, this.getLogFileName());
        this.copySplittedFiles(srcDir, destDir, this.getReportFileName());
        this.copySplittedFiles(srcDir, destDir, this.getOutputFileName());
    }

    private void copySplittedFiles(FilePath src, FilePath dest, String filename) throws IOException, InterruptedException {
        src.copyRecursiveTo(this.trimSuffix(filename) + "*" + this.getSuffix(filename), dest);
    }

    private String trimSuffix(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return filename;
    }

    private String getSuffix(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            return filename.substring(index);
        }
        return "";
    }

    private double forceValidValue(double value) {
        if (value > 100.0) {
            return 100.0;
        }
        if (value < 0.0) {
            return 0.0;
        }
        return NumberHelper.roundToDecimals((double)value, (int)1);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

