/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.graph;

import hudson.model.AbstractBuild;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotGraph
extends Graph {
    private final String yLabel;
    private final String xLabel;
    private final CategoryDataset categoryDataset;
    public static final int DEFAULT_CHART_WIDTH = 500;
    public static final int DEFAULT_CHART_HEIGHT = 200;

    public RobotGraph(AbstractBuild<?, ?> owner, CategoryDataset categoryDataset, String yLabel, String xLabel, int chartWidth, int chartHeight) {
        super(owner.getTimestamp(), chartWidth, chartHeight);
        this.yLabel = yLabel;
        this.xLabel = xLabel;
        this.categoryDataset = categoryDataset;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)this.yLabel, (CategoryDataset)this.categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.7f);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(this.xLabel);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeMinimumSize(5.0);
        rangeAxis.setLowerBound(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.green);
        renderer.setSeriesPaint(1, (Paint)Color.red);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

