/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.robot.AbstractRobotAction;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TreeSet;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotProjectAction
extends AbstractRobotAction {
    private AbstractProject<?, ?> project;

    public RobotProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public final boolean isDisplayGraph() {
        return this.project.getBuilds().size() > 0;
    }

    public RobotBuildAction getLastBuildAction() {
        return (RobotBuildAction)this.getLastFinishedBuild().getAction(RobotBuildAction.class);
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(RobotBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public Integer getLastResultBuildNumber() {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        if (lastBuild != null) {
            return lastBuild.getNumber();
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = ((AbstractBuild)this.project.getLastCompletedBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        RobotGraph g = new RobotGraph((AbstractBuild)this.project.getLastBuild(), this.getDataSet(), "Number of testcases", "Build number", 500, 200);
        g.doPng(req, rsp);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuildNumber();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/" + this.getUrlName());
        }
    }

    private CategoryDataset getDataSet() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        ArrayList<String> rows = new ArrayList<String>();
        ArrayList<ChartUtil.NumberOnlyBuildLabel> columns = new ArrayList<ChartUtil.NumberOnlyBuildLabel>();
        for (AbstractBuild build = (AbstractBuild)this.project.getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            RobotBuildAction action = (RobotBuildAction)build.getAction(RobotBuildAction.class);
            Number failed = 0;
            Number passed = 0;
            if (action != null) {
                failed = action.getAllFailed();
                passed = action.getAllPassed();
            }
            if (failed < 1) {
                failed = Float.valueOf(0.01f);
            }
            if (passed < 1) {
                passed = Float.valueOf(0.01f);
            }
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            values.add((Integer)passed);
            rows.add("Passed");
            columns.add(label);
            values.add((Integer)failed);
            rows.add("Failed");
            columns.add(label);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        TreeSet rowSet = new TreeSet(rows);
        TreeSet colSet = new TreeSet(columns);
        Comparable[] _rows = rowSet.toArray(new Comparable[rowSet.size()]);
        Comparable[] _cols = colSet.toArray(new Comparable[colSet.size()]);
        for (int i = _rows.length - 1; i >= 0; --i) {
            dataset.setValue(null, _rows[i], _cols[0]);
        }
        for (Comparable c : _cols) {
            dataset.setValue(null, _rows[0], c);
        }
        for (int i = 0; i < values.size(); ++i) {
            dataset.addValue((Number)values.get(i), (Comparable)rows.get(i), (Comparable)columns.get(i));
        }
        return dataset;
    }
}

