/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import hudson.Extension;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.SidACL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleBasedAuthorizationStrategy
extends AuthorizationStrategy {
    public static final String GLOBAL = "globalRoles";
    public static final String PROJECT = "projectRoles";
    private final Map<String, RoleMap> grantedRoles = new HashMap();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SidACL getRootACL() {
        RoleMap root = this.getRoleMap(GLOBAL);
        return root.getACL();
    }

    public ACL getACL(Job<?, ?> project) {
        RoleMap roleMap = (RoleMap)this.grantedRoles.get(PROJECT);
        SidACL acl = roleMap == null ? this.getRootACL() : roleMap.newMatchingRoleMap(project.getName()).getACL().newInheritingACL(this.getRootACL());
        return acl;
    }

    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        for (Map.Entry entry : this.grantedRoles.entrySet()) {
            RoleMap roleMap = (RoleMap)entry.getValue();
            sids.addAll(roleMap.getSids(Boolean.valueOf(true)));
        }
        return sids;
    }

    public SortedMap<Role, Set<String>> getGrantedRoles(String type) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap != null) {
            return roleMap.getGrantedRoles();
        }
        return null;
    }

    public Set<String> getSIDs(String type) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap != null) {
            return roleMap.getSids();
        }
        return null;
    }

    private RoleMap getRoleMap(String type) {
        RoleMap map;
        if (this.grantedRoles.containsKey(type)) {
            map = (RoleMap)this.grantedRoles.get(type);
        } else {
            map = new RoleMap();
            this.grantedRoles.put(type, map);
        }
        return map;
    }

    private Map<String, RoleMap> getRoleMaps() {
        return this.grantedRoles;
    }

    private void addRole(String type, Role role) {
        RoleMap roleMap = (RoleMap)this.grantedRoles.get(type);
        if (roleMap != null) {
            roleMap.addRole(role);
        } else {
            roleMap = new RoleMap();
            roleMap.addRole(role);
            this.grantedRoles.put(type, roleMap);
        }
    }

    private void assignRole(String type, Role role, String sid) {
        RoleMap roleMap = (RoleMap)this.grantedRoles.get(type);
        if (roleMap != null && roleMap.hasRole(role)) {
            roleMap.assignRole(role, sid);
        }
    }

    static /* synthetic */ Map access$000(RoleBasedAuthorizationStrategy x0) {
        return x0.getRoleMaps();
    }

    static /* synthetic */ Map access$100(RoleBasedAuthorizationStrategy x0) {
        return x0.grantedRoles;
    }

    static /* synthetic */ void access$200(RoleBasedAuthorizationStrategy x0, String x1, Role x2) {
        x0.addRole(x1, x2);
    }

    static /* synthetic */ RoleMap access$300(RoleBasedAuthorizationStrategy x0, String x1) {
        return x0.getRoleMap(x1);
    }

    static /* synthetic */ void access$400(RoleBasedAuthorizationStrategy x0, String x1, Role x2, String x3) {
        x0.assignRole(x1, x2, x3);
    }
}

