/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMap {
    private transient SidACL acl = new AclImpl(this, null);
    private final SortedMap<Role, Set<String>> grantedRoles;

    RoleMap() {
        this.grantedRoles = new TreeMap();
    }

    RoleMap(SortedMap<Role, Set<String>> grantedRoles) {
        this.grantedRoles = grantedRoles;
    }

    private boolean hasPermission(String sid, Permission p) {
        for (Role role : this.getRolesHavingPermission(p)) {
            if (!((Set)this.grantedRoles.get(role)).contains(sid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.grantedRoles.containsKey(role);
    }

    public SidACL getACL() {
        return this.acl;
    }

    public void addRole(Role role) {
        if (this.getRole(role.getName()) == null) {
            this.grantedRoles.put(role, new HashSet());
        }
    }

    public void assignRole(Role role, String sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(sid);
        }
    }

    public void clearSidsForRole(Role role) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).clear();
        }
    }

    public void clearSids() {
        for (Map.Entry entry : this.grantedRoles.entrySet()) {
            Role role = (Role)entry.getKey();
            this.clearSidsForRole(role);
        }
    }

    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public SortedMap<Role, Set<String>> getGrantedRoles() {
        return Collections.unmodifiableSortedMap(this.grantedRoles);
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.grantedRoles.keySet());
    }

    public SortedSet<String> getSids() {
        return this.getSids(Boolean.valueOf(false));
    }

    public SortedSet<String> getSids(Boolean includeAnonymous) {
        TreeSet sids = new TreeSet();
        for (Map.Entry entry : this.grantedRoles.entrySet()) {
            sids.addAll((Set)entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            sids.remove("anonymous");
        }
        return Collections.unmodifiableSortedSet(sids);
    }

    public Set<String> getSidsForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            return Collections.unmodifiableSet((Set)this.grantedRoles.get(role));
        }
        return null;
    }

    public RoleMap newMatchingRoleMap(String namePattern) {
        Set roles = this.getMatchingRoles(namePattern);
        TreeMap roleMap = new TreeMap();
        for (Role role : roles) {
            roleMap.put(role, this.grantedRoles.get(role));
        }
        return new RoleMap(roleMap);
    }

    private Set<Role> getRolesHavingPermission(Permission permission) {
        HashSet<Role> roles = new HashSet<Role>();
        HashSet<Permission> permissions = new HashSet<Permission>();
        Permission p = permission;
        while (p != null) {
            permissions.add(p);
            p = p.impliedBy;
        }
        new /* Unavailable Anonymous Inner Class!! */;
        return roles;
    }

    private Set<Role> getMatchingRoles(String namePattern) {
        HashSet<Role> roles = new HashSet<Role>();
        new /* Unavailable Anonymous Inner Class!! */;
        return roles;
    }

    static /* synthetic */ boolean access$100(RoleMap x0, String x1, Permission x2) {
        return x0.hasPermission(x1, x2);
    }
}

