/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import hudson.security.Permission;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Role
implements Comparable {
    private final String name;
    private final Pattern pattern;
    private final Set<Permission> permissions = new HashSet<Permission>();

    Role(String name, Set<Permission> permissions) {
        this(name, ".*", permissions);
    }

    Role(String name, String pattern, Set<Permission> permissions) {
        this(name, Pattern.compile(pattern), permissions);
    }

    Role(String name, Pattern pattern, Set<Permission> permissions) {
        this.name = name;
        this.pattern = pattern;
        this.permissions.addAll(permissions);
    }

    public final String getName() {
        return this.name;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final Set<Permission> getPermissions() {
        return this.permissions;
    }

    public final Boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public final Boolean hasAnyPermission(Set<Permission> permissions) {
        return CollectionUtils.containsAny(this.permissions, permissions);
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((Role)o).getName());
    }
}

