/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.plugins.rubyMetrics.rcov.RcovBuildAction;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcovProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;

    public RcovProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getDisplayName() {
        return "Rcov report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "rcov";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public RcovBuildAction getLastResult() {
        for (AbstractBuild b = (AbstractBuild)this.project.getLastStableBuild(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            RcovBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (RcovBuildAction)b.getAction(RcovBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    public Integer getLastResultBuild() {
        for (AbstractBuild b = (AbstractBuild)this.project.getLastStableBuild(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            RcovBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (RcovBuildAction)b.getAction(RcovBuildAction.class)) == null) continue;
            return b.getNumber();
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().doGraph(req, rsp);
        }
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuild();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/rcov");
        }
    }
}

