/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.plugins.rubyMetrics.HtmlParser;
import hudson.plugins.rubyMetrics.rcov.RcovParser;
import hudson.plugins.rubyMetrics.rcov.model.RcovFileResult;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Text;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class RcovParser
extends HtmlParser {
    private static final String REPORT_CLASS_VALUE = "report";
    private static final String TOTAL_LINES = "lines_total";
    private static final String CODE_LINES = "lines_code";
    private static final String TOTAL_COVERAGE = "coverage_total";
    private static final String CODE_COVERAGE = "coverage_code";

    public RcovParser(File rootFilePath) {
        super(rootFilePath);
    }

    public RcovResult parse(File file) throws IOException {
        return this.parse((InputStream)new FileInputStream(file));
    }

    public RcovResult parse(InputStream input) throws IOException {
        try {
            RcovResult result = new RcovResult();
            Parser parser = this.initParser(this.getHtml(input));
            TableTag report = this.getReportTable(parser);
            if (report.getRowCount() > 0) {
                TableRow totalRow = report.getRow(1);
                result.setTotalLines(this.getColumnByClassName(totalRow, "td", TOTAL_LINES));
                result.setCodeLines(this.getColumnByClassName(totalRow, "td", CODE_LINES));
                result.setTotalCoverage(this.getColumnByClassName(totalRow, "tt", TOTAL_COVERAGE));
                result.setCodeCoverage(this.getColumnByClassName(totalRow, "tt", CODE_COVERAGE));
                for (int i = 2; i < report.getRowCount(); ++i) {
                    result.addFile(this.parseRow(report.getRow(i)));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException2("cannot parse rcov report file", (Throwable)e);
        }
    }

    protected TableTag getReportTable(Parser htmlParser) throws ParserException {
        AndFilter filter = new AndFilter((NodeFilter)new TagNameFilter("table"), (NodeFilter)new HasAttributeFilter("class", REPORT_CLASS_VALUE));
        NodeList reportNode = htmlParser.extractAllNodesThatMatch((NodeFilter)filter);
        if (reportNode == null || reportNode.size() <= 0) {
            throw new ParserException("cannot parse rcov report file, report element wasn't found");
        }
        return (TableTag)reportNode.elements().nextNode();
    }

    private RcovFileResult parseRow(TableRow row) throws ParserException, IOException {
        RcovFileResult file = new RcovFileResult();
        NodeList nodeList = new NodeList();
        row.collectInto(nodeList, (NodeFilter)new TagNameFilter("a"));
        String linkPath = null;
        if (nodeList.size() > 0) {
            LinkTag link = (LinkTag)nodeList.elementAt(0);
            linkPath = link.getLink();
            file.setHref(link.getLink().replaceAll(".html", ""));
            file.setName(link.getLinkText());
        }
        file.setTotalLines(this.getColumnByClassName(row, "td", TOTAL_LINES));
        file.setCodeLines(this.getColumnByClassName(row, "td", CODE_LINES));
        file.setTotalCoverage(this.getColumnByClassName(row, "tt", TOTAL_COVERAGE));
        file.setCodeCoverage(this.getColumnByClassName(row, "tt", CODE_COVERAGE));
        file.setSourceCode(this.parseSource(linkPath));
        return file;
    }

    private String getColumnByClassName(TableRow row, String tagName, String className) {
        NodeList nodeList = new NodeList();
        row.collectInto(nodeList, (NodeFilter)new AndFilter((NodeFilter)new TagNameFilter(tagName), (NodeFilter)new HasAttributeFilter("class", className)));
        String text = null;
        if (nodeList.size() > 0) {
            Node first = nodeList.elementAt(0);
            nodeList = new NodeList();
            Node parent = first.getChildren() != null && first.getChildren().size() > 0 ? first : first.getParent();
            parent.collectInto(nodeList, (NodeFilter)new NodeClassFilter(Text.class));
            text = nodeList.elementAt(0).getText();
        }
        return text;
    }

    private String parseSource(String href) throws ParserException, IOException {
        String html = null;
        File[] sourceFile = this.rootFilePath.listFiles((FilenameFilter)new RcovFilenameFilter(href));
        if (sourceFile != null && sourceFile.length > 0 && sourceFile[0].exists()) {
            html = this.getHtml((InputStream)new FileInputStream(sourceFile[0]));
            Pattern pattern = Pattern.compile(".+<table class='report'>.+(<pre>(.+)</pre>).+");
            Matcher matcher = pattern.matcher(html);
            if (matcher.matches()) {
                html = matcher.group(1);
            }
        }
        return html;
    }
}

