/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsStats;

import hudson.plugins.rubyMetrics.railsStats.model.RailsStatsMetrics;
import hudson.plugins.rubyMetrics.railsStats.model.RailsStatsResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsStatsParser {
    public RailsStatsResults parse(StringOutputStream output) {
        return this.parse(output.toString());
    }

    public RailsStatsResults parse(String output) {
        RailsStatsResults response = new RailsStatsResults();
        String[] aux = output.split("[\n\r]");
        Collection<String> lines = new LinkedHashSet<String>(Arrays.asList(aux));
        lines = this.removeSeparators(lines);
        Iterator<String> linesIterator = lines.iterator();
        String[] header = this.cleanArray(linesIterator.next().split("[|]+"));
        while (linesIterator.hasNext()) {
            String line = linesIterator.next();
            String[] columns = this.cleanArray(line.split("[|]+"));
            if (columns.length > 1) {
                TreeMap<RailsStatsMetrics, Integer> metrics = new TreeMap<RailsStatsMetrics, Integer>(new RailsStatsMetrics.COMPARATOR());
                for (int i = 1; i < header.length; ++i) {
                    metrics.put(RailsStatsMetrics.toRailsStatsMetrics(header[i].trim()), Integer.valueOf(columns[i].trim()));
                }
                response.addMetric(columns[0].trim(), metrics);
                continue;
            }
            Pattern pattern = Pattern.compile("CodeLOC:([0-9]+)TestLOC:([0-9]+)CodetoTestRatio:([0-9:.]+)");
            Matcher matcher = pattern.matcher(columns[0].replaceAll("[\\s\\r\\n+-]+", ""));
            if (!matcher.matches()) continue;
            response.setCodeLocSummary(matcher.group(1));
            response.setTestLocSummary(matcher.group(2));
            response.setCodeToTestRatio(matcher.group(3));
        }
        return response;
    }

    private Collection<String> removeSeparators(Collection<String> lines) {
        LinkedHashSet<String> response = new LinkedHashSet<String>();
        for (String line : lines) {
            response.add(line.replaceAll("[\\r\\n+-]+", ""));
        }
        response.remove("");
        return response;
    }

    private String[] cleanArray(String[] array) {
        ArrayList<String> response = new ArrayList<String>(Arrays.asList(array));
        response.remove("");
        return response.toArray(new String[response.size()]);
    }
}

