/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsStats;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.StreamBuildListener;
import hudson.plugins.rake.Rake;
import hudson.plugins.rake.RubyInstallation;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsPublisher;
import hudson.plugins.rubyMetrics.railsStats.RailsStatsBuildAction;
import hudson.plugins.rubyMetrics.railsStats.RailsStatsParser;
import hudson.plugins.rubyMetrics.railsStats.RailsStatsProjectAction;
import hudson.plugins.rubyMetrics.railsStats.model.RailsStatsResults;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.plexus.util.StringOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsStatsPublisher
extends AbstractRubyMetricsPublisher {
    private final Rake rake;
    private final String rakeInstallation;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RailsStatsPublisher(String rakeInstallation) {
        this.rakeInstallation = rakeInstallation;
        this.rake = new Rake(this.rakeInstallation, null, "stats", null, null, true);
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Project project = (Project)build.getParent();
        FilePath workspace = project.getModuleRoot();
        if (!this.isRailsProject(workspace)) {
            return this.fail(build, listener, "This is not a rails app directory: " + workspace.getName());
        }
        listener.getLogger().println("Publishing rails stats report...");
        StringOutputStream out = new StringOutputStream();
        StreamBuildListener stringListener = new StreamBuildListener((OutputStream)out);
        if (this.rake.perform(build, launcher, (BuildListener)stringListener)) {
            RailsStatsParser parser = new RailsStatsParser();
            RailsStatsResults results = parser.parse(out);
            RailsStatsBuildAction action = new RailsStatsBuildAction((AbstractBuild<?, ?>)build, results);
            build.getActions().add(action);
        }
        return true;
    }

    public String getRakeInstallation() {
        return this.rakeInstallation;
    }

    private boolean isRailsProject(FilePath workspace) {
        try {
            return workspace.isDirectory() && workspace.list("app") != null && workspace.list("config") != null && workspace.list("db") != null && workspace.list("test") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Action getProjectAction(Project project) {
        return new RailsStatsProjectAction((AbstractProject<?, ?>)project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        protected DescriptorImpl() {
            super(RailsStatsPublisher.class);
        }

        public String getHelpFile() {
            return "/plugin/rubyMetrics/railsStatsHelp.html";
        }

        public String getDisplayName() {
            return "Publish Rails stats report";
        }

        public RubyInstallation[] getRakeInstallations() {
            return Rake.DESCRIPTOR.getInstallations();
        }
    }
}

