/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.saikuro;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.rubyMetrics.HtmlPublisher;
import hudson.plugins.rubyMetrics.saikuro.SaikuroBuildAction;
import hudson.plugins.rubyMetrics.saikuro.SaikuroParser;
import hudson.plugins.rubyMetrics.saikuro.SaikuroProjectAction;
import hudson.plugins.rubyMetrics.saikuro.model.SaikuroResult;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaikuroPublisher
extends HtmlPublisher {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SaikuroPublisher(String reportDir) {
        this.reportDir = reportDir;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SaikuroFilenameFilter indexFilter = new SaikuroFilenameFilter();
        this.prepareMetricsReportBeforeParse(build, listener, indexFilter, DESCRIPTOR.getToolShortName());
        if (build.getResult() == Result.FAILURE) {
            return false;
        }
        SaikuroParser parser = new SaikuroParser(build.getRootDir(), listener);
        SaikuroResult results = parser.parse(this.getCoverageFiles(build, indexFilter)[0]);
        SaikuroBuildAction action = new SaikuroBuildAction((AbstractBuild<?, ?>)build, results);
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SaikuroProjectAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        protected DescriptorImpl() {
            super(SaikuroPublisher.class);
        }

        public String getToolShortName() {
            return "saikuro";
        }

        public String getDisplayName() {
            return "Publish Saikuro report";
        }

        public SaikuroPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            return (SaikuroPublisher)((Object)req.bindParameters(SaikuroPublisher.class, "saikuro."));
        }
    }

    private static class SaikuroFilenameFilter
    implements FilenameFilter {
        private SaikuroFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase("index_cyclo.html");
        }
    }
}

