/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.rubyMetrics.HtmlPublisher;
import hudson.plugins.rubyMetrics.rcov.RcovBuildAction;
import hudson.plugins.rubyMetrics.rcov.RcovParser;
import hudson.plugins.rubyMetrics.rcov.RcovProjectAction;
import hudson.plugins.rubyMetrics.rcov.RcovPublisher;
import hudson.plugins.rubyMetrics.rcov.model.MetricTarget;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.tasks.Publisher;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcovPublisher
extends HtmlPublisher {
    private List<MetricTarget> targets;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RcovPublisher(String reportDir) {
        this.reportDir = reportDir;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        RcovFilenameFilter indexFilter = new RcovFilenameFilter(null);
        this.prepareMetricsReportBeforeParse(build, listener, (FilenameFilter)indexFilter, DESCRIPTOR.getToolShortName());
        if (build.getResult() == Result.FAILURE) {
            return false;
        }
        RcovParser parser = new RcovParser(build.getRootDir());
        RcovResult results = parser.parse(this.getCoverageFiles(build, (FilenameFilter)indexFilter)[0]);
        RcovBuildAction action = new RcovBuildAction(build, results, this.targets);
        build.getActions().add(action);
        if (this.failMetrics(results, listener)) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private boolean failMetrics(RcovResult results, BuildListener listener) {
        float initRatio = 0.0f;
        float resultRatio = 0.0f;
        for (MetricTarget target : this.targets) {
            initRatio = target.getUnstable().intValue();
            resultRatio = results.getRatioFloat(target.getMetric()).floatValue();
            if (!(resultRatio < initRatio)) continue;
            listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
            listener.getLogger().println("    " + target.getMetric().getName());
            return true;
        }
        return false;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new RcovProjectAction(project);
    }

    public List<MetricTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<MetricTarget> targets) {
        this.targets = targets;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

