/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics;

import hudson.FilePath;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsPublisher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlPublisher
extends AbstractRubyMetricsPublisher {
    protected String reportDir;

    public String getReportDir() {
        return this.reportDir;
    }

    protected boolean moveReportsToBuildRootDir(FilePath workspace, Build<?, ?> build, BuildListener listener) throws InterruptedException {
        try {
            FilePath coverageDir = workspace.child(this.reportDir);
            if (!coverageDir.exists()) {
                listener.getLogger().println("file not found: " + coverageDir);
                return false;
            }
            coverageDir.copyRecursiveTo("**/*", new FilePath(build.getRootDir()));
            return true;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    protected boolean prepareMetricsReportBeforeParse(Build<?, ?> build, BuildListener listener, FilenameFilter indexFilter, String toolShortName) throws InterruptedException {
        if (!Result.SUCCESS.equals(build.getResult())) {
            listener.getLogger().println("Build wasn't successful, skipping " + toolShortName + " coverage report");
            return true;
        }
        listener.getLogger().println("Publishing " + toolShortName + " report...");
        Project project = (Project)build.getParent();
        FilePath workspace = project.getModuleRoot();
        boolean copied = this.moveReportsToBuildRootDir(workspace, build, listener);
        if (!copied) {
            return this.fail(build, listener, toolShortName + " report directory wasn't found using the pattern '" + this.reportDir + "'.");
        }
        File[] coverageFiles = build.getRootDir().listFiles(indexFilter);
        if (coverageFiles == null || coverageFiles.length == 0) {
            return this.fail(build, listener, toolShortName + " report index file wasn't found");
        }
        return true;
    }

    protected File[] getCoverageFiles(Build<?, ?> build, FilenameFilter indexFilter) {
        return build.getRootDir().listFiles(indexFilter);
    }
}

