/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.plugins.rubyMetrics.HtmlParser;
import hudson.plugins.rubyMetrics.rcov.model.RcovFileResult;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Text;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class RcovParser
extends HtmlParser {
    private static final String REPORT_CLASS_VALUE = "report";
    private static final String TOTAL_LINES = "lines_total";
    private static final String CODE_LINES = "lines_code";
    private static final String TOTAL_COVERAGE = "coverage_total";
    private static final String CODE_COVERAGE = "coverage_code";

    public RcovParser(File rootFilePath) {
        super(rootFilePath);
    }

    public RcovResult parse(File file) throws IOException {
        return this.parse(new FileInputStream(file));
    }

    public RcovResult parse(InputStream input) throws IOException {
        try {
            RcovResult result = new RcovResult();
            Parser parser = this.initParser(this.getHtml(input));
            TableTag report = this.getReportTable(parser);
            if (report.getRowCount() > 0) {
                TableRow totalRow = report.getRow(1);
                TableColumn[] columns = totalRow.getColumns();
                result.setTotalLines(this.getTextFromTT(columns[1]));
                result.setCodeLines(this.getTextFromTT(columns[2]));
                result.setTotalCoverage(this.getTextFromTT(columns[3]));
                result.setCodeCoverage(this.getTextFromTT(columns[4]));
                for (int i = 2; i < report.getRowCount(); ++i) {
                    result.addFile(this.parseRow(report.getRow(i)));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException2("cannot parse rcov report file", (Throwable)e);
        }
    }

    protected TableTag getReportTable(Parser htmlParser) throws ParserException {
        AndFilter filter = new AndFilter((NodeFilter)new TagNameFilter("table"), (NodeFilter)new HasAttributeFilter("class", REPORT_CLASS_VALUE));
        NodeList reportNode = htmlParser.extractAllNodesThatMatch((NodeFilter)filter);
        if (reportNode == null || reportNode.size() <= 0) {
            throw new ParserException("cannot parse rcov report file, report element wasn't found");
        }
        return (TableTag)reportNode.elements().nextNode();
    }

    private RcovFileResult parseRow(TableRow row) throws ParserException, IOException {
        RcovFileResult file = new RcovFileResult();
        NodeList nodeList = new NodeList();
        row.collectInto(nodeList, (NodeFilter)new TagNameFilter("a"));
        String linkPath = null;
        if (nodeList.size() > 0) {
            LinkTag link = (LinkTag)nodeList.elementAt(0);
            linkPath = link.getLink();
            file.setHref(link.getLink().replaceAll(".html", ""));
            file.setName(link.getLinkText());
        }
        TableColumn[] columns = row.getColumns();
        file.setTotalLines(this.getTextFromTT(columns[1]));
        file.setCodeLines(this.getTextFromTT(columns[2]));
        file.setTotalCoverage(this.getTextFromTT(columns[3]));
        file.setCodeCoverage(this.getTextFromTT(columns[4]));
        file.setSourceCode(this.parseSource(linkPath));
        return file;
    }

    private String getColumnByClassName(TableRow row, String tagName, String className) {
        NodeList nodeList = new NodeList();
        row.collectInto(nodeList, (NodeFilter)new AndFilter((NodeFilter)new TagNameFilter(tagName), (NodeFilter)new HasAttributeFilter("class", className)));
        return this.getTextFromFirstNode(nodeList);
    }

    private String getTextFromTT(TableColumn td) {
        NodeList nodeList = new NodeList();
        td.collectInto(nodeList, (NodeFilter)new TagNameFilter("tt"));
        return this.getTextFromFirstNode(nodeList);
    }

    private String getTextFromFirstNode(NodeList nodeList) {
        String text = null;
        if (nodeList.size() > 0) {
            Node first = nodeList.elementAt(0);
            nodeList = new NodeList();
            Node parent = first.getChildren() != null && first.getChildren().size() > 0 ? first : first.getParent();
            parent.collectInto(nodeList, (NodeFilter)new NodeClassFilter(Text.class));
            text = nodeList.toHtml(true).replaceAll("&nbsp;", "").trim();
        }
        return text;
    }

    private String parseSource(String href) throws ParserException, IOException {
        String html = null;
        File[] sourceFile = this.rootFilePath.listFiles(new RcovFilenameFilter(href));
        if (sourceFile != null && sourceFile.length > 0 && sourceFile[0].exists()) {
            html = this.getHtml(new FileInputStream(sourceFile[0]));
            Pattern pattern = Pattern.compile(".+<table class='report'>.+(<pre>(.+)</pre>).+");
            Matcher matcher = pattern.matcher(html);
            if (matcher.matches()) {
                html = matcher.group(1);
            }
        }
        return html;
    }

    private static class RcovFilenameFilter
    implements FilenameFilter {
        String fileName;

        public RcovFilenameFilter(String fileName) {
            this.fileName = fileName;
        }

        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase(this.fileName);
        }
    }
}

