/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.rubyMetrics.RubyMetricsPublisher;
import hudson.plugins.rubyMetrics.rcov.RcovBuildAction;
import hudson.plugins.rubyMetrics.rcov.RcovParser;
import hudson.plugins.rubyMetrics.rcov.RcovProjectAction;
import hudson.plugins.rubyMetrics.rcov.RcovPublisher;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcovPublisher
extends RubyMetricsPublisher {
    private final String reportDir;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RcovPublisher(String reportDir) {
        this.reportDir = reportDir;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!Result.SUCCESS.equals(build.getResult())) {
            listener.getLogger().println("Build wasn't successful, skipping rcov coverage report");
            return true;
        }
        listener.getLogger().println("Publishing Rcov report...");
        Project project = (Project)build.getParent();
        FilePath workspace = project.getModuleRoot();
        boolean copied = this.moveReportsToBuildRootDir(workspace, build, listener);
        if (!copied) {
            return this.fail(build, listener, "Rcov report directory wasn't found using the pattern '" + this.reportDir + "'.");
        }
        RcovFilenameFilter indexFilter = new RcovFilenameFilter(null);
        File[] coverageFiles = build.getRootDir().listFiles((FilenameFilter)indexFilter);
        if (coverageFiles == null || coverageFiles.length <= 0) {
            return this.fail(build, listener, "Rcov report index file wasn't found");
        }
        RcovParser parser = new RcovParser(build.getRootDir());
        RcovResult results = parser.parse(coverageFiles[0]);
        RcovBuildAction action = new RcovBuildAction(build, results);
        build.getActions().add(action);
        return true;
    }

    private boolean moveReportsToBuildRootDir(FilePath workspace, Build<?, ?> build, BuildListener listener) throws InterruptedException {
        try {
            FilePath coverageDir = workspace.child(this.reportDir);
            if (!coverageDir.exists()) {
                listener.getLogger().println("file not found: " + coverageDir);
                return false;
            }
            int copied = coverageDir.copyRecursiveTo("**/*", new FilePath(build.getRootDir()));
            return true;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new RcovProjectAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

