/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.flog;

import hudson.model.AbstractBuild;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsBuildAction;
import hudson.plugins.rubyMetrics.flog.model.FlogBuildResults;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlogBuildAction
extends AbstractRubyMetricsBuildAction {
    private final FlogBuildResults results;

    public FlogBuildAction(AbstractBuild<?, ?> owner, FlogBuildResults results) {
        super(owner);
        this.results = results;
    }

    protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (FlogBuildAction action = this; action != null; action = (FlogBuildAction)action.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(action.owner);
            dsb.add((Number)Float.valueOf(this.results.getTotal()), (Comparable)((Object)"Total score"), (Comparable)label);
            dsb.add((Number)Float.valueOf(this.results.getAverage()), (Comparable)((Object)"Average score"), (Comparable)label);
        }
        return dsb;
    }

    protected NumberAxis getRangeAxis(CategoryPlot plot) {
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)(new BigDecimal(this.results.getTotal()).round(MathContext.DECIMAL32).intValue() + 20));
        rangeAxis.setLowerBound(0.0);
        return rangeAxis;
    }

    public FlogBuildResults getResults() {
        return this.results;
    }

    public String getDisplayName() {
        return "Flog report";
    }

    public String getUrlName() {
        return "flog";
    }
}

