/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsNotes;

import hudson.plugins.rubyMetrics.railsNotes.model.RailsNotesMetrics;
import hudson.plugins.rubyMetrics.railsNotes.model.RailsNotesResults;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.StringOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsNotesParser {
    public RailsNotesResults parse(StringOutputStream output) {
        return this.parse(output.toString());
    }

    public RailsNotesResults parse(String output) {
        RailsNotesResults response = new RailsNotesResults();
        String[] aux = output.split("[\n\r]");
        Collection<String> lines = new LinkedHashSet<String>(Arrays.asList(aux));
        lines = this.removeSeparators(lines);
        Iterator<String> linesIterator = lines.iterator();
        String lastFile = "";
        block0: while (linesIterator.hasNext()) {
            String line = linesIterator.next();
            if (StringUtils.isEmpty((String)line.trim())) continue;
            if (line.charAt(0) != ' ') {
                lastFile = line.substring(0, line.length() - 1);
                continue;
            }
            for (RailsNotesMetrics metric : RailsNotesMetrics.values()) {
                Pattern metricPattern = Pattern.compile("^  \\* \\[[\\s\\d]+\\] \\[" + metric.toString() + "\\]");
                if (!metricPattern.matcher(line).find()) continue;
                response.addAnnotationFor(lastFile, metric);
                continue block0;
            }
        }
        response.setOutput(output);
        return response;
    }

    private Collection<String> removeSeparators(Collection<String> lines) {
        LinkedHashSet<String> response = new LinkedHashSet<String>();
        for (String line : lines) {
            response.add(line.replaceAll("[\\r\\n+-]+", ""));
        }
        response.remove("");
        return response;
    }
}

