/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsNotes.model;

import hudson.plugins.rubyMetrics.railsNotes.model.RailsNotesMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsNotesResults {
    private Map<String, Map<RailsNotesMetrics, Integer>> metrics = new HashMap<String, Map<RailsNotesMetrics, Integer>>();
    private List<String> sortedLabels = new ArrayList<String>();
    private String output;

    public Collection<String> getHeaders() {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        headers.add("Filename");
        for (RailsNotesMetrics metric : RailsNotesMetrics.values()) {
            headers.add(metric.toString());
        }
        return headers;
    }

    public void addAnnotationFor(String fileName, RailsNotesMetrics annotation) {
        Map<Object, Object> metric;
        if (!this.sortedLabels.contains(fileName)) {
            this.sortedLabels.add(fileName);
        }
        if (!this.metrics.containsKey(fileName)) {
            metric = new TreeMap();
            for (RailsNotesMetrics value : RailsNotesMetrics.values()) {
                metric.put((Object)value, new Integer(0));
            }
            this.metrics.put(fileName, metric);
        }
        metric = this.metrics.get(fileName);
        metric.put((Object)annotation, new Integer((Integer)metric.get((Object)annotation) + 1));
    }

    public Map<RailsNotesMetrics, Integer> getTotal() {
        TreeMap<RailsNotesMetrics, Integer> total = new TreeMap<RailsNotesMetrics, Integer>();
        for (RailsNotesMetrics metric : RailsNotesMetrics.values()) {
            total.put(metric, new Integer(0));
        }
        for (Map<RailsNotesMetrics, Integer> fileEntry : this.metrics.values()) {
            for (RailsNotesMetrics metric : fileEntry.keySet()) {
                total.put(metric, new Integer((Integer)total.get((Object)metric) + fileEntry.get((Object)metric)));
            }
        }
        return total;
    }

    public Map<String, Map<RailsNotesMetrics, Integer>> getMetrics() {
        SortLabelsComparator comparator = new SortLabelsComparator(this.sortedLabels);
        TreeMap<String, Map<RailsNotesMetrics, Integer>> response = new TreeMap<String, Map<RailsNotesMetrics, Integer>>(comparator);
        for (Map.Entry<String, Map<RailsNotesMetrics, Integer>> entry : this.metrics.entrySet()) {
            response.put(entry.getKey(), entry.getValue());
        }
        response.put("Total", this.getTotal());
        return response;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortLabelsComparator
    implements Comparator<String> {
        private final List<String> labels;

        public SortLabelsComparator(List<String> coll) {
            this.labels = coll;
        }

        @Override
        public int compare(String o1, String o2) {
            return new Integer(this.labels.indexOf(o1)).compareTo(this.labels.indexOf(o2));
        }
    }
}

