/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsBuildAction;
import hudson.plugins.rubyMetrics.rcov.model.MetricTarget;
import hudson.plugins.rubyMetrics.rcov.model.RcovFileDetail;
import hudson.plugins.rubyMetrics.rcov.model.RcovFileResult;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.plugins.rubyMetrics.rcov.model.Targets;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcovBuildAction
extends AbstractRubyMetricsBuildAction {
    private final RcovResult results;
    private final List<MetricTarget> targets;

    public RcovBuildAction(AbstractBuild<?, ?> owner, RcovResult results, List<MetricTarget> targets) {
        super(owner);
        this.results = results;
        this.targets = targets;
    }

    public HealthReport getBuildHealth() {
        int minValue = 100;
        Targets minMetric = null;
        for (MetricTarget target : this.targets) {
            int value = this.calcRangeScore(target.getHealthy(), target.getUnhealthy(), this.results.getRatioFloat(target.getMetric()).intValue());
            if (value > minValue) continue;
            minValue = value;
            minMetric = target.getMetric();
        }
        HealthReport report = minMetric != null ? new HealthReport(minValue, this.results.getHealthDescription(minMetric)) : null;
        return report;
    }

    public String getDisplayName() {
        return "Rcov report";
    }

    public String getUrlName() {
        return "rcov";
    }

    public RcovResult getResults() {
        return this.results;
    }

    private int calcRangeScore(Integer max, Integer min, int value) {
        int result;
        if (min == null || min < 0) {
            min = 0;
        }
        if (max == null || max > 100) {
            max = 100;
        }
        if (min > max) {
            min = max - 1;
        }
        if ((result = (int)(100.0f * ((float)value - min.floatValue()) / (max.floatValue() - min.floatValue()))) < 0) {
            return 0;
        }
        if (result > 100) {
            return 100;
        }
        return result;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (link.startsWith("file.")) {
            String file = link.substring(link.indexOf("file.") + 5);
            RcovFileResult fileResult = this.getResults().getFile(file);
            return new RcovFileDetail(this.owner, fileResult);
        }
        return null;
    }

    protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (RcovBuildAction a = this; a != null; a = (RcovBuildAction)a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.owner);
            dsb.add((Number)a.getResults().getTotalCoverageFloat(), (Comparable)((Object)"total coverage"), (Comparable)label);
            dsb.add((Number)a.getResults().getCodeCoverageFloat(), (Comparable)((Object)"code coverage"), (Comparable)label);
        }
        return dsb;
    }

    protected String getRangeAxisLabel() {
        return "%";
    }
}

