/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsPublisher;
import hudson.plugins.rubyMetrics.Utils;
import java.io.File;
import java.io.FilenameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlPublisher
extends AbstractRubyMetricsPublisher {
    protected String reportDir;

    public String getReportDir() {
        return this.reportDir;
    }

    protected boolean prepareMetricsReportBeforeParse(AbstractBuild<?, ?> build, BuildListener listener, FilenameFilter indexFilter, String toolShortName) throws InterruptedException {
        if (!Result.SUCCESS.equals(build.getResult())) {
            listener.getLogger().println("Build wasn't successful, skipping " + toolShortName + " coverage report");
            return true;
        }
        listener.getLogger().println("Publishing " + toolShortName + " report...");
        FilePath workspace = build.getModuleRoot();
        boolean copied = Utils.moveReportsToBuildRootDir(workspace, build.getRootDir(), (TaskListener)listener, this.reportDir, "**/*");
        if (!copied) {
            build.setResult(Result.FAILURE);
            return this.fail(build, listener, toolShortName + " report directory wasn't found using the pattern '" + this.reportDir + "'.");
        }
        File[] coverageFiles = build.getRootDir().listFiles(indexFilter);
        if (coverageFiles == null || coverageFiles.length == 0) {
            return this.fail(build, listener, toolShortName + " report index file wasn't found");
        }
        return true;
    }

    protected File[] getCoverageFiles(AbstractBuild<?, ?> build, FilenameFilter indexFilter) {
        return build.getRootDir().listFiles(indexFilter);
    }
}

