/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsStats.model;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RailsStatsMetrics {
    LINES,
    LOC,
    CLASSES,
    METHODS,
    M_C,
    LOC_M;


    public String prettyPrint() {
        switch (this) {
            case LOC: {
                return this.toString();
            }
            case M_C: {
                return this.slashedPrint();
            }
            case LOC_M: {
                return this.slashedPrint();
            }
        }
        return this.defaultPrettyPrint();
    }

    private String defaultPrettyPrint() {
        String prettyString = this.toString().toLowerCase();
        return prettyString.substring(0, 1).toUpperCase() + prettyString.substring(1);
    }

    private String slashedPrint() {
        return this.toString().replaceAll("_", "/");
    }

    public static RailsStatsMetrics toRailsStatsMetrics(String name) {
        try {
            return RailsStatsMetrics.valueOf(name.toUpperCase().replaceAll("/", "_"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getOrder() {
        return Arrays.asList(RailsStatsMetrics.values()).indexOf((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class COMPARATOR
    implements Comparator<RailsStatsMetrics> {
        @Override
        public int compare(RailsStatsMetrics o1, RailsStatsMetrics o2) {
            return new Integer(o1.getOrder()).compareTo(new Integer(o2.getOrder()));
        }
    }
}

