/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.flog;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.rubyMetrics.Utils;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.StringOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlogExecutor {
    public boolean isFlogInstalled(Launcher launcher, EnvVars environment, FilePath workspace) {
        try {
            StringOutputStream out = this.launch(this.arguments("--help"), launcher, environment, workspace);
            return out != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, StringOutputStream> execute(String[] rbDirectories, Launcher launcher, EnvVars environment, FilePath workspace, File buildRootDir) throws InterruptedException, IOException {
        HashMap<String, StringOutputStream> results = new HashMap<String, StringOutputStream>();
        for (String relativePath : rbDirectories) {
            FilePath[] rubyFiles;
            if (workspace.child(relativePath) == null) {
                launcher.getListener().getLogger().println("the path: " + relativePath + " doesn't exist into the workpace, ignoring it");
                continue;
            }
            for (FilePath rubyFile : rubyFiles = this.getRubyFiles(workspace, buildRootDir, relativePath, launcher)) {
                String rubyFilePath = rubyFile.toURI().getPath();
                ArgumentListBuilder arguments = this.arguments("-ad", rubyFilePath);
                StringOutputStream out = this.launch(arguments, launcher, environment, workspace);
                if (out == null) {
                    results.clear();
                    return results;
                }
                results.put(this.prettifyFilePath(relativePath, rubyFilePath), out);
            }
        }
        return results;
    }

    public StringOutputStream launch(ArgumentListBuilder arguments, Launcher launcher, EnvVars environment, FilePath workspace) throws InterruptedException, IOException {
        StringOutputStream out = new StringOutputStream();
        int result = launcher.launch().cmds(arguments).envs((Map)environment).stdout((OutputStream)out).pwd(workspace).join();
        return result >= 0 ? out : null;
    }

    public ArgumentListBuilder arguments(String ... args) {
        ArgumentListBuilder flogArguments = new ArgumentListBuilder();
        flogArguments.add("flog");
        for (String arg : args) {
            flogArguments.add(arg);
        }
        return flogArguments;
    }

    private FilePath[] getRubyFiles(FilePath workspace, File buildRootDir, String relativePath, Launcher launcher) throws InterruptedException, IOException {
        Utils.moveReportsToBuildRootDir(workspace, buildRootDir, launcher.getListener(), relativePath, "**/*.rb", true);
        FilePath classesLocation = new FilePath(new File(buildRootDir, relativePath));
        launcher.getListener().getLogger().println("searching ruby classes into: " + classesLocation.toURI().getPath());
        return classesLocation.list("**/*.rb");
    }

    private String prettifyFilePath(String path, String rubyFilePath) {
        return rubyFilePath.substring(rubyFilePath.indexOf(path));
    }
}

