/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.flog;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsPublisher;
import hudson.plugins.rubyMetrics.flog.FlogBuildAction;
import hudson.plugins.rubyMetrics.flog.FlogExecutor;
import hudson.plugins.rubyMetrics.flog.FlogParser;
import hudson.plugins.rubyMetrics.flog.FlogProjectAction;
import hudson.plugins.rubyMetrics.flog.model.FlogBuildResults;
import hudson.plugins.rubyMetrics.flog.model.FlogFileResults;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Map;
import org.codehaus.plexus.util.StringOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlogPublisher
extends AbstractRubyMetricsPublisher {
    private final String rbDirectories;
    private final String[] splittedDirectories;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FlogPublisher(String rbDirectories) {
        this.rbDirectories = rbDirectories;
        this.splittedDirectories = (this.rbDirectories != null && this.rbDirectories.length() > 0 ? this.rbDirectories : ".").split("[\t\r\n]+");
    }

    public String getRbDirectories() {
        return this.rbDirectories;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace;
        FlogExecutor flog = new FlogExecutor();
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        if (!flog.isFlogInstalled(launcher, environment, workspace = build.getModuleRoot())) {
            return this.fail(build, listener, "Seems flog is not installed. Ensure flog is in your PATH");
        }
        listener.getLogger().println("Publishing flog report...");
        Map<String, StringOutputStream> execResults = flog.execute(this.splittedDirectories, launcher, environment, workspace, build.getRootDir());
        FlogBuildResults buildResults = this.buildResults(build, execResults);
        FlogBuildAction action = new FlogBuildAction(build, buildResults);
        build.getActions().add(action);
        return true;
    }

    private FlogBuildResults buildResults(AbstractBuild<?, ?> build, Map<String, StringOutputStream> execResults) {
        FlogParser parser = new FlogParser();
        FlogBuildResults buildResults = new FlogBuildResults();
        for (Map.Entry<String, StringOutputStream> entry : execResults.entrySet()) {
            FlogFileResults resultsForFile = parser.parse(entry.getKey(), entry.getValue());
            if (resultsForFile == null) continue;
            buildResults.addFileResults(entry.getKey(), resultsForFile);
        }
        return buildResults;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new FlogProjectAction(project);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Flog report";
        }
    }
}

