/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsStats.model;

import hudson.plugins.rubyMetrics.railsStats.model.RailsStatsMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsStatsResults {
    private Map<String, Map<RailsStatsMetrics, Integer>> metrics = new HashMap<String, Map<RailsStatsMetrics, Integer>>();
    private List<String> sortedLabels = new ArrayList<String>();
    private String codeLocSummary;
    private String testLocSummary;
    private String codeToTestRatio;

    public Collection<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Name");
        for (RailsStatsMetrics metric : RailsStatsMetrics.values()) {
            headers.add(metric.prettyPrint());
        }
        return headers;
    }

    public void addMetric(String classType, Map<RailsStatsMetrics, Integer> metric) {
        this.metrics.put(classType, metric);
        if (!this.sortedLabels.contains(classType)) {
            this.sortedLabels.add(classType);
        }
    }

    public Map<RailsStatsMetrics, Integer> getTotal() {
        return this.metrics.get("Total");
    }

    public Map<String, Map<RailsStatsMetrics, Integer>> getMetrics() {
        SortLabelsComparator comparator = new SortLabelsComparator(this.sortedLabels);
        TreeMap<String, Map<RailsStatsMetrics, Integer>> response = new TreeMap<String, Map<RailsStatsMetrics, Integer>>(comparator);
        for (Map.Entry<String, Map<RailsStatsMetrics, Integer>> entry : this.metrics.entrySet()) {
            response.put(entry.getKey(), entry.getValue());
        }
        return response;
    }

    public void setMetrics(Map<String, Map<RailsStatsMetrics, Integer>> metrics) {
        this.metrics = metrics;
    }

    public String getCodeLocSummary() {
        return this.codeLocSummary;
    }

    public void setCodeLocSummary(String codeLocSummary) {
        this.codeLocSummary = codeLocSummary;
    }

    public String getTestLocSummary() {
        return this.testLocSummary;
    }

    public void setTestLocSummary(String testLocSummary) {
        this.testLocSummary = testLocSummary;
    }

    public String getCodeToTestRatio() {
        return this.codeToTestRatio;
    }

    public void setCodeToTestRatio(String codeToTestRatio) {
        this.codeToTestRatio = codeToTestRatio;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortLabelsComparator
    implements Comparator<String> {
        private final List<String> sortedLabels;

        public SortLabelsComparator(List<String> coll) {
            this.sortedLabels = coll;
        }

        @Override
        public int compare(String o1, String o2) {
            return new Integer(this.sortedLabels.indexOf(o1)).compareTo(this.sortedLabels.indexOf(o2));
        }
    }
}

