/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.rubyMetrics.HtmlPublisher;
import hudson.plugins.rubyMetrics.rcov.RcovBuildAction;
import hudson.plugins.rubyMetrics.rcov.RcovParser;
import hudson.plugins.rubyMetrics.rcov.RcovProjectAction;
import hudson.plugins.rubyMetrics.rcov.model.MetricTarget;
import hudson.plugins.rubyMetrics.rcov.model.RcovResult;
import hudson.plugins.rubyMetrics.rcov.model.Targets;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcovPublisher
extends HtmlPublisher {
    private List<MetricTarget> targets;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RcovPublisher(String reportDir) {
        this.reportDir = reportDir;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        RcovFilenameFilter indexFilter = new RcovFilenameFilter();
        this.prepareMetricsReportBeforeParse(build, listener, indexFilter, DESCRIPTOR.getToolShortName());
        if (build.getResult() == Result.FAILURE) {
            return false;
        }
        RcovParser parser = new RcovParser(build.getRootDir());
        RcovResult results = parser.parse(this.getCoverageFiles(build, indexFilter)[0]);
        RcovBuildAction action = new RcovBuildAction(build, results, this.targets);
        build.getActions().add(action);
        if (this.failMetrics(results, listener)) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private boolean failMetrics(RcovResult results, BuildListener listener) {
        float initRatio = 0.0f;
        float resultRatio = 0.0f;
        for (MetricTarget target : this.targets) {
            initRatio = target.getUnstable().intValue();
            resultRatio = results.getRatioFloat(target.getMetric()).floatValue();
            if (!(resultRatio < initRatio)) continue;
            listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
            listener.getLogger().println("    " + target.getMetric().getName());
            return true;
        }
        return false;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new RcovProjectAction(project);
    }

    public List<MetricTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<MetricTarget> targets) {
        this.targets = targets;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private static class RcovFilenameFilter
    implements FilenameFilter {
        private RcovFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase("index.html");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final List<MetricTarget> targets = new ArrayList<MetricTarget>(){
            {
                this.add(new MetricTarget(Targets.TOTAL_COVERAGE, 80, null, null));
                this.add(new MetricTarget(Targets.CODE_COVERAGE, 80, null, null));
            }
        };

        protected DescriptorImpl() {
            super(RcovPublisher.class);
        }

        public String getToolShortName() {
            return "rcov";
        }

        public String getDisplayName() {
            return "Publish Rcov report";
        }

        public List<MetricTarget> getTargets(RcovPublisher instance) {
            return instance != null && instance.getTargets() != null ? instance.getTargets() : this.getDefaultTargets();
        }

        private List<MetricTarget> getDefaultTargets() {
            return this.targets;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public RcovPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            RcovPublisher instance = (RcovPublisher)((Object)req.bindParameters(RcovPublisher.class, "rcov."));
            ConvertUtils.register((Converter)MetricTarget.CONVERTER, Targets.class);
            List targets = req.bindParametersToList(MetricTarget.class, "rcov.target.");
            instance.setTargets(targets);
            return instance;
        }
    }
}

