/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.rcov.model;

import hudson.plugins.rubyMetrics.rcov.model.Targets;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;

public class MetricTarget {
    private final Targets metric;
    private final Integer healthy;
    private final Integer unhealthy;
    private final Integer unstable;
    public static final TargetConverter CONVERTER = new TargetConverter();

    @DataBoundConstructor
    public MetricTarget(Targets metric, Integer healthy, Integer unhealthy, Integer unstable) {
        this.metric = metric;
        this.healthy = healthy != null ? healthy : 80;
        this.unhealthy = unhealthy;
        this.unstable = unstable;
    }

    public Targets getMetric() {
        return this.metric;
    }

    public Integer getHealthy() {
        return this.healthy != null ? this.healthy : 0;
    }

    public Integer getUnhealthy() {
        return this.unhealthy != null ? this.unhealthy : 0;
    }

    public Integer getUnstable() {
        return this.unstable != null ? this.unstable : 0;
    }

    private static class TargetConverter
    implements Converter {
        private TargetConverter() {
        }

        public Object convert(Class type, Object value) {
            return Targets.resolve(value.toString());
        }
    }
}

