/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.saikuro;

import hudson.model.AbstractBuild;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsBuildAction;
import hudson.plugins.rubyMetrics.saikuro.model.SaikuroFileDetail;
import hudson.plugins.rubyMetrics.saikuro.model.SaikuroFileResult;
import hudson.plugins.rubyMetrics.saikuro.model.SaikuroResult;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaikuroBuildAction
extends AbstractRubyMetricsBuildAction {
    private SaikuroResult results;

    public SaikuroBuildAction(AbstractBuild<?, ?> owner, SaikuroResult results) {
        super(owner);
        this.results = results;
    }

    @Override
    protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (SaikuroBuildAction a = this; a != null; a = (SaikuroBuildAction)a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.owner);
            dsb.add((Number)a.getResults().getTotalComplexityAsInt(), (Comparable)((Object)"total complexity"), (Comparable)label);
        }
        return dsb;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (link.startsWith("file.")) {
            String file = link.substring(link.indexOf("file.") + 5);
            SaikuroFileResult fileResult = this.getResults().getFile(file);
            return new SaikuroFileDetail(this.owner, fileResult);
        }
        return null;
    }

    public String getDisplayName() {
        return "Saikuro report";
    }

    public String getUrlName() {
        return "saikuro";
    }

    public SaikuroResult getResults() {
        return this.results;
    }
}

