/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics.railsNotes.model;

import hudson.plugins.rubyMetrics.railsNotes.model.RailsNotesMetrics;
import hudson.plugins.rubyMetrics.railsNotes.model.RailsNotesResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsNotesResults {
    private Map<String, Map<RailsNotesMetrics, Integer>> metrics = new HashMap();
    private List<String> sortedLabels = new ArrayList();
    private String output;

    public Collection<String> getHeaders() {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        headers.add("Filename");
        for (RailsNotesMetrics metric : RailsNotesMetrics.values()) {
            headers.add(metric.toString());
        }
        return headers;
    }

    public void addAnnotationFor(String fileName, RailsNotesMetrics annotation) {
        Map<RailsNotesMetrics, Integer> metric;
        if (!this.sortedLabels.contains(fileName)) {
            this.sortedLabels.add(fileName);
        }
        if (!this.metrics.containsKey(fileName)) {
            metric = new TreeMap();
            for (RailsNotesMetrics value : RailsNotesMetrics.values()) {
                metric.put(value, new Integer(0));
            }
            this.metrics.put(fileName, metric);
        }
        metric = (Map)this.metrics.get(fileName);
        metric.put(annotation, new Integer((Integer)metric.get(annotation) + 1));
    }

    public Map<RailsNotesMetrics, Integer> getTotal() {
        TreeMap<RailsNotesMetrics, Integer> total = new TreeMap<RailsNotesMetrics, Integer>();
        for (RailsNotesMetrics metric : RailsNotesMetrics.values()) {
            total.put(metric, new Integer(0));
        }
        for (Map fileEntry : this.metrics.values()) {
            for (RailsNotesMetrics metric : fileEntry.keySet()) {
                total.put(metric, new Integer((Integer)total.get(metric) + (Integer)fileEntry.get(metric)));
            }
        }
        return total;
    }

    public Map<String, Map<RailsNotesMetrics, Integer>> getMetrics() {
        SortLabelsComparator comparator = new SortLabelsComparator(this, this.sortedLabels);
        TreeMap<String, Map<RailsNotesMetrics, Integer>> response = new TreeMap<String, Map<RailsNotesMetrics, Integer>>((Comparator<String>)comparator);
        for (Map.Entry entry : this.metrics.entrySet()) {
            response.put((String)entry.getKey(), (Map<RailsNotesMetrics, Integer>)entry.getValue());
        }
        response.put("Total", this.getTotal());
        return response;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

