/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rubyMetrics;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.StreamBuildListener;
import hudson.plugins.rake.Rake;
import hudson.plugins.rubyMetrics.AbstractRubyMetricsPublisher;
import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.plexus.util.StringOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRailsTaskPublisher
extends AbstractRubyMetricsPublisher {
    protected final Rake rake;
    protected final String rakeInstallation;
    protected final String rakeWorkingDir;
    private final String task;

    protected AbstractRailsTaskPublisher(String rakeInstallation, String rakeWorkingDir, String task) {
        this.rakeInstallation = rakeInstallation;
        this.rakeWorkingDir = rakeWorkingDir;
        this.task = task;
        this.rake = new Rake(this.rakeInstallation, null, task, null, this.rakeWorkingDir, true);
    }

    public String getRakeInstallation() {
        return this.rakeInstallation;
    }

    public String getRakeWorkingDir() {
        return this.rakeWorkingDir;
    }

    private boolean isRailsProject(FilePath workspace) {
        try {
            return workspace != null && workspace.isDirectory() && workspace.list("app") != null && workspace.list("config") != null && workspace.list("db") != null && workspace.list("test") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getModuleRoot();
        if (!this.isRailsProject(workspace)) {
            String message = "Your workspace is not a valid rails application directory";
            if (workspace != null) {
                message = message + ": " + workspace.getName();
            }
            return this.fail(build, listener, message);
        }
        listener.getLogger().println("Publishing rails " + this.task + " report...");
        StringOutputStream out = new StringOutputStream();
        StreamBuildListener stringListener = new StreamBuildListener((OutputStream)out);
        if (this.rake.perform(build, launcher, (BuildListener)stringListener)) {
            this.buildAction(out, build);
        }
        return true;
    }

    protected abstract void buildAction(StringOutputStream var1, AbstractBuild<?, ?> var2);
}

