/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SbtPluginBuilder
extends Builder {
    private final String actions;
    private final String jvmFlags;
    private final String sbtFlags;

    @DataBoundConstructor
    public SbtPluginBuilder(String jvmFlags, String sbtFlags, String actions) {
        this.jvmFlags = jvmFlags;
        this.sbtFlags = sbtFlags;
        this.actions = actions;
    }

    public String getJvmFlags() {
        return this.jvmFlags;
    }

    public String getSbtFlags() {
        return this.sbtFlags;
    }

    public String getActions() {
        return this.actions;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        EnvVars env = null;
        FilePath workDir = build.getModuleRoot();
        try {
            ArgumentListBuilder cmdLine = this.buildCmdLine(build, launcher, listener);
            String[] cmds = cmdLine.toCommandArray();
            env = build.getEnvironment((TaskListener)listener);
            int exitValue = launcher.launch().cmds(cmds).envs((Map)env).stdout((TaskListener)listener).pwd(workDir).join();
            boolean success = exitValue == 0;
            build.setResult(success ? Result.SUCCESS : Result.FAILURE);
            return success;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private ArgumentListBuilder buildCmdLine(AbstractBuild build, Launcher launcher, BuildListener listener) throws IllegalArgumentException {
        String[] split;
        ArgumentListBuilder args = new ArgumentListBuilder();
        String sbtJarPath = this.getDescriptor().getSbtJarPath();
        if (StringUtils.isBlank((String)sbtJarPath)) {
            throw new IllegalArgumentException("SBT jar path is empty");
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"cmd.exe", "/C"});
        }
        String java = build.getProject().getJDK() != null ? build.getProject().getJDK().getBinDir() + "/java" : "java";
        args.add(new File(java).getAbsolutePath());
        for (String flag : split = this.jvmFlags.split(" ")) {
            args.add(flag);
        }
        for (String flag : split = this.sbtFlags.split(" ")) {
            args.add(flag);
        }
        args.add("-jar");
        args.add(sbtJarPath);
        for (String action : split = this.actions.split(" ")) {
            args.add(action);
        }
        return args;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String sbtJarPath;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckSbtJarPath(@QueryParameter String value) throws IOException, ServletException {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Please enter a path");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Build using SBT";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.sbtJarPath = formData.getString("sbtJarPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getSbtJarPath() {
            return this.sbtJarPath;
        }
    }
}

