/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scis_ad;

import hudson.FilePath;
import hudson.model.AdministrativeMonitor;
import hudson.model.Hudson;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScisSupportOffer
extends AdministrativeMonitor {
    public volatile boolean active;

    public ScisSupportOffer() {
        Hudson h = Hudson.getInstance();
        File marker1 = new File(h.getRootDir(), "secret.key");
        File marker2 = new File(h.getRootDir(), "scis-reminder");
        long t = Math.max(marker1.lastModified(), marker2.lastModified());
        if (t > 0L) {
            long d = TimeUnit2.MILLISECONDS.toDays(System.currentTimeMillis() - t);
            this.active = d > 60L && h.getItems().size() > 20 && new Random().nextInt(10) == 0;
        }
        this.active |= Boolean.getBoolean("forceAd");
    }

    public boolean isActivated() {
        return this.active;
    }

    public void doAct(StaplerRequest req, StaplerResponse rsp, @QueryParameter String yes, @QueryParameter String no) throws IOException, InterruptedException {
        if (yes != null) {
            rsp.sendRedirect("http://hudson-ci.org/scis");
            return;
        }
        if (no != null) {
            this.disable(true);
        } else {
            this.active = false;
            new FilePath(Hudson.getInstance().getRootDir()).child("scis-reminder").touch(System.currentTimeMillis());
        }
        rsp.sendRedirect(req.getContextPath() + "/manage");
    }
}

