/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationBusiness;
import hudson.plugins.scm_sync_configuration.scms.SCM;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.HudsonConfigScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.JobConfigScmSyncStrategy;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScmSyncConfigurationPlugin
extends Plugin {
    private static final transient ScmSyncStrategy[] AVAILABLE_STRATEGIES = new ScmSyncStrategy[]{new JobConfigScmSyncStrategy(), new HudsonConfigScmSyncStrategy()};
    private transient ScmSyncConfigurationBusiness business;
    private String scmRepositoryUrl;
    private SCM scm;

    public ScmSyncConfigurationPlugin() {
        this.setBusiness(new ScmSyncConfigurationBusiness(this));
    }

    public void start() throws Exception {
        super.start();
        this.load();
        this.business.start();
    }

    public void stop() throws Exception {
        this.business.stop();
        super.stop();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        super.configure(req, formData);
        this.scm = SCM.valueOf((String)req.getParameter("scm"));
        String newScmRepositoryUrl = this.scm.createScmUrlFromRequest(req);
        if (newScmRepositoryUrl != null && !newScmRepositoryUrl.equals(this.scmRepositoryUrl)) {
            this.scmRepositoryUrl = newScmRepositoryUrl;
            this.save();
            this.business.initializeRepository(true);
            this.business.synchronizeAllConfigs(AVAILABLE_STRATEGIES, ScmSyncConfigurationPlugin.getCurrentUser());
        }
    }

    public void doSubmitComment(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        req.getSession().setAttribute("commitMessage", (Object)req.getParameter("comment"));
    }

    public void doHelpForRepositoryUrl(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        req.getView((Object)this, SCM.valueOf((String)req.getParameter("scm")).getRepositoryUrlHelpPath()).forward((ServletRequest)req, (ServletResponse)res);
    }

    public void commitFile(XmlFile modifiedFile) {
        this.business.synchronizeFile(modifiedFile.getFile(), ScmSyncConfigurationPlugin.getCurrentComment(), ScmSyncConfigurationPlugin.getCurrentUser());
    }

    private static String getCurrentComment() {
        StaplerRequest req = Stapler.getCurrentRequest();
        String comment = null;
        if (req != null) {
            comment = (String)req.getSession().getAttribute("commitMessage");
        }
        return comment;
    }

    private static User getCurrentUser() {
        User user = null;
        try {
            user = Hudson.getInstance().getMe();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return user;
    }

    public static ScmSyncConfigurationPlugin getInstance() {
        return (ScmSyncConfigurationPlugin)Hudson.getInstance().getPlugin(ScmSyncConfigurationPlugin.class);
    }

    public ScmSyncStrategy getStrategyForSaveable(Saveable s) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isSaveableApplicable(s)) continue;
            return strat;
        }
        return null;
    }

    public boolean shouldDecorationOccursOnURL(String url) {
        return this.getStrategyForURL(url) != null && this.business.scmConfigurationSettledUp();
    }

    public ScmSyncStrategy getStrategyForURL(String url) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isCurrentUrlApplicable(url)) continue;
            return strat;
        }
        return null;
    }

    public SCM[] getScms() {
        return SCM.values();
    }

    public void setBusiness(ScmSyncConfigurationBusiness business) {
        this.business = business;
    }

    public String getScmRepositoryUrl() {
        return this.scmRepositoryUrl;
    }

    public boolean isScmSelected(SCM _scm) {
        return this.scm == _scm;
    }

    public String getScmUrl() {
        if (this.scm != null) {
            return this.scm.extractScmUrlFrom(this.scmRepositoryUrl);
        }
        return null;
    }

    public Descriptor getDescriptorForSCM(String scmName) {
        return Hudson.getInstance().getDescriptorByName(SCM.valueOf((String)scmName).getSCMDescriptorClassName());
    }
}

