/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationPlugin;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.FileUtils;

public class ScmSyncConfigurationBusiness {
    private static final String WORKING_DIRECTORY_PATH = "/scm-sync-configuration/";
    private static final String CHECKOUT_SCM_DIRECTORY = "checkoutConfiguration";
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationBusiness.class.getName());
    private ScmSyncConfigurationPlugin plugin;
    private Embedder plexus;
    private ScmManager scmManager;
    private ScmRepository scmRepository = null;
    private File checkoutScmDirectory = null;

    public ScmSyncConfigurationBusiness(ScmSyncConfigurationPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() throws Exception {
        this.plexus = new Embedder();
        this.plexus.start();
        this.scmManager = (ScmManager)this.plexus.lookup(ScmManager.ROLE);
        this.checkoutScmDirectory = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        this.initializeRepository(false);
    }

    public void stop() throws Exception {
        this.plexus.stop();
    }

    public void initializeRepository(boolean deleteCheckoutScmDir) {
        if (this.scmConfigurationSettledUp()) {
            if (deleteCheckoutScmDir && this.checkoutScmDirectory.exists()) {
                try {
                    FileUtils.forceDelete((File)this.checkoutScmDirectory);
                }
                catch (IOException e) {
                    LOGGER.throwing(FileUtils.class.getName(), "forceDelete", e);
                }
            }
            try {
                this.scmManager.checkOut(this.scmRepository, new ScmFileSet(this.checkoutScmDirectory));
            }
            catch (ScmException e) {
                LOGGER.throwing(ScmManager.class.getName(), "checkOut", e);
            }
        }
    }

    public boolean scmConfigurationSettledUp() {
        String scmRepositoryUrl = this.plugin.getScmRepositoryUrl();
        if (scmRepositoryUrl == null) {
            return false;
        }
        try {
            this.scmRepository = this.scmManager.makeScmRepository(scmRepositoryUrl);
        }
        catch (ScmRepositoryException e) {
        }
        catch (NoSuchScmProviderException e) {
            // empty catch block
        }
        if (!this.checkoutScmDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)this.checkoutScmDirectory);
            }
            catch (IOException e) {
                LOGGER.warning("Directory <" + this.checkoutScmDirectory.getAbsolutePath() + "> cannot be created !");
                return false;
            }
        }
        return this.scmRepository != null;
    }

    public void synchronizeFile(File modifiedFile, String comment, User user) {
        if (!this.scmConfigurationSettledUp()) {
            return;
        }
        String modifiedFilePathRelativeToHudsonRoot = this.buildPathRelativeToHudsonRoot(modifiedFile);
        StringBuilder commitMessage = new StringBuilder();
        commitMessage.append("Modification on file");
        if (user != null) {
            commitMessage.append(" by ").append(user.getId());
        }
        if (comment != null) {
            commitMessage.append(" with following comment : ").append(comment);
        }
        File modifiedFileTranslatedInScm = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + modifiedFilePathRelativeToHudsonRoot);
        boolean modifiedFileAlreadySynchronized = modifiedFileTranslatedInScm.exists();
        try {
            FileUtils.copyFile((File)modifiedFile, (File)modifiedFileTranslatedInScm);
        }
        catch (IOException e) {
            LOGGER.throwing(FileUtils.class.getName(), "copyFile", e);
        }
        File scmRoot = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        ArrayList<File> synchronizedFiles = new ArrayList<File>();
        if (!modifiedFileAlreadySynchronized) {
            try {
                String[] pathChunks = modifiedFilePathRelativeToHudsonRoot.split("\\\\|/");
                StringBuilder currentPath = new StringBuilder();
                for (int i = 0; i < pathChunks.length - 1; ++i) {
                    currentPath.append(pathChunks[i]).append(File.separator);
                    File currentFile = new File(currentPath.toString());
                    AddScmResult addResult = this.scmManager.add(this.scmRepository, new ScmFileSet(scmRoot, currentFile));
                    if (!addResult.isSuccess()) continue;
                    synchronizedFiles.add(currentFile);
                }
                currentPath.append(pathChunks[pathChunks.length - 1]);
                this.scmManager.add(this.scmRepository, new ScmFileSet(scmRoot, new File(currentPath.toString())));
            }
            catch (ScmException e) {
                LOGGER.throwing(ScmManager.class.getName(), "add", e);
            }
        }
        synchronizedFiles.add(new File(modifiedFilePathRelativeToHudsonRoot));
        ScmFileSet fileSet = new ScmFileSet(scmRoot, synchronizedFiles);
        try {
            this.scmManager.checkIn(this.scmRepository, fileSet, commitMessage.toString());
        }
        catch (ScmException e) {
            LOGGER.throwing(ScmManager.class.getName(), "checkIn", e);
        }
    }

    public void synchronizeAllConfigs(ScmSyncStrategy[] availableStrategies, User user) {
        ArrayList<File> filesToSync = new ArrayList<File>();
        for (ScmSyncStrategy strategy : availableStrategies) {
            filesToSync.addAll(strategy.createInitializationSynchronizedFileset());
        }
        for (File fileToSync : filesToSync) {
            String hudsonConfigPathRelativeToHudsonRoot = this.buildPathRelativeToHudsonRoot(fileToSync);
            File hudsonConfigTranslatedInScm = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + hudsonConfigPathRelativeToHudsonRoot);
            try {
                if (hudsonConfigTranslatedInScm.exists() && FileUtils.contentEquals((File)hudsonConfigTranslatedInScm, (File)fileToSync)) continue;
                this.synchronizeFile(fileToSync, "Synchronization init", user);
            }
            catch (IOException e) {}
        }
    }

    private String buildPathRelativeToHudsonRoot(File filePath) {
        File hudsonRoot = Hudson.getInstance().getRootDir();
        if (!filePath.getAbsolutePath().startsWith(hudsonRoot.getAbsolutePath())) {
            throw new IllegalArgumentException("Err ! File <" + filePath.getAbsolutePath() + "> seems not to reside in <" + hudsonRoot.getAbsolutePath() + "> !");
        }
        return filePath.getAbsolutePath().substring(hudsonRoot.getAbsolutePath().length() + 1);
    }

    private static String getCheckoutScmDirectoryAbsolutePath() {
        return Hudson.getInstance().getRootDir().getAbsolutePath() + WORKING_DIRECTORY_PATH + CHECKOUT_SCM_DIRECTORY;
    }
}

