/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies.impl;

import hudson.model.Hudson;
import hudson.model.Job;
import hudson.plugins.scm_sync_configuration.strategies.AbstractScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.model.PageMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConfigScmSyncStrategy
extends AbstractScmSyncStrategy<Job> {
    private static final List<PageMatcher> PAGE_MATCHERS = new ArrayList<PageMatcher>(){
        {
            this.add(new PageMatcher("^job/[^/]+/configure$", "config"));
        }
    };

    public JobConfigScmSyncStrategy() {
        super(Job.class, PAGE_MATCHERS);
    }

    @Override
    public List<File> createInitializationSynchronizedFileset() {
        ArrayList<File> syncedFiles = new ArrayList<File>();
        File hudsonJobsDirectory = new File(Hudson.getInstance().getRootDir().getAbsolutePath() + File.separator + "jobs");
        for (File hudsonJob : hudsonJobsDirectory.listFiles()) {
            if (!hudsonJob.isDirectory()) continue;
            File hudsonJobConfig = new File(hudsonJob.getAbsoluteFile() + File.separator + "config.xml");
            syncedFiles.add(hudsonJobConfig);
        }
        return syncedFiles;
    }
}

