/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.HudsonFilesHelper;
import hudson.plugins.scm_sync_configuration.SCMManagerFactory;
import hudson.plugins.scm_sync_configuration.SCMManipulator;
import hudson.plugins.scm_sync_configuration.model.ScmContext;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.maven.scm.manager.ScmManager;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScmSyncConfigurationBusiness {
    private static final String WORKING_DIRECTORY_PATH = "/scm-sync-configuration/";
    private static final String CHECKOUT_SCM_DIRECTORY = "checkoutConfiguration";
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationBusiness.class.getName());
    private SCMManipulator scmManipulator;
    private File checkoutScmDirectory = null;

    public void init(ScmContext scmContext) throws ComponentLookupException, PlexusContainerException {
        ScmManager scmManager = SCMManagerFactory.getInstance().createScmManager();
        this.scmManipulator = new SCMManipulator(scmManager);
        this.checkoutScmDirectory = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        this.initializeRepository(scmContext, false);
    }

    public void initializeRepository(ScmContext scmContext, boolean deleteCheckoutScmDir) {
        if (this.scmManipulator.scmConfigurationSettledUp(scmContext, true)) {
            LOGGER.info("Initializing SCM repository for scm-sync-configuration plugin ...");
            if (deleteCheckoutScmDir) {
                this.cleanChekoutScmDirectory();
            }
            if (!this.checkoutScmDirectory.exists()) {
                try {
                    FileUtils.forceMkdir((File)this.checkoutScmDirectory);
                    LOGGER.info("Directory <" + this.checkoutScmDirectory.getAbsolutePath() + "> created !");
                }
                catch (IOException e) {
                    LOGGER.warning("Directory <" + this.checkoutScmDirectory.getAbsolutePath() + "> cannot be created !");
                }
            }
            if (this.scmManipulator.checkout(this.checkoutScmDirectory)) {
                LOGGER.info("SCM repository initialization done.");
            }
        }
    }

    public void cleanChekoutScmDirectory() {
        if (this.checkoutScmDirectory.exists()) {
            LOGGER.info("Deleting old checkout SCM directory ...");
            try {
                FileUtils.forceDelete((File)this.checkoutScmDirectory);
            }
            catch (IOException e) {
                LOGGER.throwing(FileUtils.class.getName(), "forceDelete", e);
                LOGGER.severe("Error while deleting <" + this.checkoutScmDirectory.getAbsolutePath() + "> : " + e.getMessage());
            }
        }
    }

    public void deleteHierarchy(ScmContext scmContext, File rootHierarchy, User user) {
        this.deleteHierarchy(scmContext, rootHierarchy, ScmSyncConfigurationBusiness.createCommitMessage((String)"Hierarchy deleted", (User)user, null));
    }

    public void deleteHierarchy(ScmContext scmContext, File rootHierarchy, String commitMessage) {
        if (!this.scmManipulator.scmConfigurationSettledUp(scmContext, false)) {
            return;
        }
        String rootHierarchyPathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot((File)rootHierarchy);
        File rootHierarchyTranslatedInScm = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + rootHierarchyPathRelativeToHudsonRoot);
        this.scmManipulator.deleteHierarchy(rootHierarchyTranslatedInScm, commitMessage);
    }

    public void renameHierarchy(ScmContext scmContext, File oldDir, File newDir, User user) {
        if (!this.scmManipulator.scmConfigurationSettledUp(scmContext, false)) {
            return;
        }
        String oldDirPathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot((File)oldDir);
        String newDirPathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot((File)newDir);
        File scmRoot = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        String commitMessage = ScmSyncConfigurationBusiness.createCommitMessage((String)("Moved " + oldDirPathRelativeToHudsonRoot + " hierarchy to " + newDirPathRelativeToHudsonRoot), (User)user, null);
        LOGGER.info("Renaming hierarchy <" + oldDirPathRelativeToHudsonRoot + "> to <" + newDirPathRelativeToHudsonRoot + ">");
        this.scmManipulator.renameHierarchy(scmRoot, oldDirPathRelativeToHudsonRoot, newDirPathRelativeToHudsonRoot, commitMessage);
    }

    public void synchronizeFile(ScmContext scmContext, File modifiedFile, String comment, User user) {
        if (!this.scmManipulator.scmConfigurationSettledUp(scmContext, false)) {
            return;
        }
        String modifiedFilePathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot((File)modifiedFile);
        LOGGER.info("Synchronizeing file <" + modifiedFilePathRelativeToHudsonRoot + "> to SCM ...");
        String commitMessage = ScmSyncConfigurationBusiness.createCommitMessage((String)"Modification on file", (User)user, (String)comment);
        File modifiedFileTranslatedInScm = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + modifiedFilePathRelativeToHudsonRoot);
        boolean modifiedFileAlreadySynchronized = modifiedFileTranslatedInScm.exists();
        try {
            FileUtils.copyFile((File)modifiedFile, (File)modifiedFileTranslatedInScm);
        }
        catch (IOException e) {
            LOGGER.throwing(FileUtils.class.getName(), "copyFile", e);
            LOGGER.severe("Error while copying file : " + e.getMessage());
            return;
        }
        File scmRoot = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        ArrayList<File> synchronizedFiles = new ArrayList<File>();
        if (!modifiedFileAlreadySynchronized) {
            synchronizedFiles.addAll(this.scmManipulator.addFile(scmRoot, modifiedFilePathRelativeToHudsonRoot));
        } else {
            synchronizedFiles.add(new File(modifiedFilePathRelativeToHudsonRoot));
        }
        if (this.scmManipulator.checkinFiles(scmRoot, synchronizedFiles, commitMessage)) {
            LOGGER.info("Synchronized file <" + modifiedFilePathRelativeToHudsonRoot + "> to SCM !");
        }
    }

    public void synchronizeAllConfigs(ScmContext scmContext, ScmSyncStrategy[] availableStrategies, User user) {
        ArrayList filesToSync = new ArrayList();
        for (ScmSyncStrategy strategy : availableStrategies) {
            filesToSync.addAll(strategy.createInitializationSynchronizedFileset());
        }
        for (File fileToSync : filesToSync) {
            String hudsonConfigPathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot((File)fileToSync);
            File hudsonConfigTranslatedInScm = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + hudsonConfigPathRelativeToHudsonRoot);
            try {
                if (hudsonConfigTranslatedInScm.exists() && FileUtils.contentEquals((File)hudsonConfigTranslatedInScm, (File)fileToSync)) continue;
                this.synchronizeFile(scmContext, fileToSync, "Synchronization init", user);
            }
            catch (IOException e) {}
        }
    }

    public boolean scmConfigurationSettledUp(ScmContext scmContext) {
        return this.scmManipulator.scmConfigurationSettledUp(scmContext, false);
    }

    private static String createCommitMessage(String messagePrefix, User user, String comment) {
        StringBuilder commitMessage = new StringBuilder();
        commitMessage.append(messagePrefix);
        if (user != null) {
            commitMessage.append(" by ").append(user.getId());
        }
        if (comment != null) {
            commitMessage.append(" with following comment : ").append(comment);
        }
        return commitMessage.toString();
    }

    private static String getCheckoutScmDirectoryAbsolutePath() {
        return Hudson.getInstance().getRootDir().getAbsolutePath() + "/scm-sync-configuration/" + "checkoutConfiguration";
    }
}

