/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import com.thoughtworks.xstream.converters.Converter;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.SCMManagerFactory;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationBusiness;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationDataProvider;
import hudson.plugins.scm_sync_configuration.model.ScmContext;
import hudson.plugins.scm_sync_configuration.scms.SCM;
import hudson.plugins.scm_sync_configuration.scms.impl.ScmSyncNoSCM;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.HudsonConfigScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.JobConfigScmSyncStrategy;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ScmSyncConfigurationPlugin
extends Plugin {
    public static final transient ScmSyncStrategy[] AVAILABLE_STRATEGIES = new ScmSyncStrategy[]{new JobConfigScmSyncStrategy(), new HudsonConfigScmSyncStrategy()};
    private transient ScmSyncConfigurationBusiness business;
    private String scmRepositoryUrl;
    private SCM scm;

    public ScmSyncConfigurationPlugin() {
        this.setBusiness(new ScmSyncConfigurationBusiness());
    }

    public void start() throws Exception {
        super.start();
        Hudson.XSTREAM.registerConverter((Converter)new SCM.SCMXStreamConverter());
        this.load();
        if (this.scm == null) {
            this.scm = SCM.valueOf((String)new ScmSyncNoSCM().getId());
            this.scmRepositoryUrl = null;
        }
        SCMManagerFactory.getInstance().start();
    }

    public void init() {
        try {
            this.business.init(this.createScmContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Error during ScmSyncConfiguration initialisation !", e);
        }
    }

    public void stop() throws Exception {
        SCMManagerFactory.getInstance().stop();
        super.stop();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        super.configure(req, formData);
        String scmType = req.getParameter("scm");
        if (scmType != null) {
            this.scm = SCM.valueOf((String)scmType);
            String newScmRepositoryUrl = this.scm.createScmUrlFromRequest(req);
            String oldScmRepositoryUrl = this.scmRepositoryUrl;
            this.scmRepositoryUrl = newScmRepositoryUrl;
            this.save();
            if (newScmRepositoryUrl != null && !newScmRepositoryUrl.equals(oldScmRepositoryUrl)) {
                this.business.initializeRepository(this.createScmContext(), true);
                this.business.synchronizeAllConfigs(this.createScmContext(), AVAILABLE_STRATEGIES, this.getCurrentUser());
            } else if (newScmRepositoryUrl == null && oldScmRepositoryUrl != null) {
                this.business.cleanChekoutScmDirectory();
            }
        }
    }

    public void doSubmitComment(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        ScmSyncConfigurationDataProvider.provideComment((StaplerRequest)req, (String)req.getParameter("comment"));
    }

    public void doHelpForRepositoryUrl(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        req.getView((Object)this, SCM.valueOf((String)req.getParameter("scm")).getRepositoryUrlHelpPath()).forward((ServletRequest)req, (ServletResponse)res);
    }

    public void deleteHierarchy(File rootHierarchy) {
        this.business.deleteHierarchy(this.createScmContext(), rootHierarchy, this.getCurrentUser());
    }

    public void renameHierarchy(File oldDir, File newDir) {
        this.business.renameHierarchy(this.createScmContext(), oldDir, newDir, this.getCurrentUser());
    }

    public void synchronizeFile(File modifiedFile) {
        this.business.synchronizeFile(this.createScmContext(), modifiedFile, ScmSyncConfigurationPlugin.getCurrentComment(), this.getCurrentUser());
    }

    private static String getCurrentComment() {
        StaplerRequest req = Stapler.getCurrentRequest();
        String comment = null;
        if (req != null) {
            comment = ScmSyncConfigurationDataProvider.retrieveComment((StaplerRequest)req, (boolean)false);
        }
        return comment;
    }

    private User getCurrentUser() {
        User user = null;
        try {
            user = Hudson.getInstance().getMe();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return user;
    }

    public static ScmSyncConfigurationPlugin getInstance() {
        return (ScmSyncConfigurationPlugin)Hudson.getInstance().getPlugin(ScmSyncConfigurationPlugin.class);
    }

    public ScmSyncStrategy getStrategyForSaveable(Saveable s, File f) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isSaveableApplicable(s, f)) continue;
            return strat;
        }
        return null;
    }

    public ScmContext createScmContext() {
        return new ScmContext(this.scm, this.scmRepositoryUrl);
    }

    public boolean shouldDecorationOccursOnURL(String url) {
        ScmSyncConfigurationDataProvider.retrieveComment((StaplerRequest)Stapler.getCurrentRequest(), (boolean)true);
        return this.getStrategyForURL(url) != null && this.business.scmConfigurationSettledUp(this.createScmContext());
    }

    public ScmSyncStrategy getStrategyForURL(String url) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isCurrentUrlApplicable(url)) continue;
            return strat;
        }
        return null;
    }

    public SCM[] getScms() {
        return SCM.values();
    }

    public void setBusiness(ScmSyncConfigurationBusiness business) {
        this.business = business;
    }

    public String getScmRepositoryUrl() {
        return this.scmRepositoryUrl;
    }

    public boolean isScmSelected(SCM _scm) {
        return this.scm == _scm;
    }

    public SCM getSCM() {
        return this.scm;
    }

    public String getScmUrl() {
        if (this.scm != null) {
            return this.scm.extractScmUrlFrom(this.scmRepositoryUrl);
        }
        return null;
    }

    public Descriptor<? extends hudson.scm.SCM> getDescriptorForSCM(String scmName) {
        return SCM.valueOf((String)scmName).getSCMDescriptor();
    }
}

