/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.scms.impl;

import hudson.plugins.scm_sync_configuration.scms.SCM;
import hudson.plugins.scm_sync_configuration.scms.SCMCredentialConfiguration;
import hudson.scm.SubversionSCM;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class ScmSyncSubversionSCM
extends SCM {
    private static final String SCM_URL_PREFIX = "scm:svn:";

    public ScmSyncSubversionSCM() {
        super("Subversion", "svn/config.jelly", "hudson.scm.SubversionSCM", "/hudson/plugins/scm_sync_configuration/ScmSyncConfigurationPlugin/scms/svn/url-help.jelly");
    }

    public String createScmUrlFromRequest(StaplerRequest req) {
        String repoURL = req.getParameter("repositoryUrl");
        if (repoURL == null) {
            return null;
        }
        return SCM_URL_PREFIX + repoURL;
    }

    public String extractScmUrlFrom(String scmUrl) {
        return scmUrl.substring(SCM_URL_PREFIX.length());
    }

    public SCMCredentialConfiguration extractScmCredentials(String scmUrl) {
        LOGGER.info("Extracting SVN Credentials for url : " + scmUrl);
        String realm = this.retrieveRealmFor(scmUrl);
        if (realm != null) {
            LOGGER.fine("Extracted realm from " + scmUrl + " is <" + realm + ">");
            SubversionSCM.DescriptorImpl subversionDescriptor = (SubversionSCM.DescriptorImpl)this.getSCMDescriptor();
            try {
                Field credentialField = SubversionSCM.DescriptorImpl.class.getDeclaredField("credentials");
                credentialField.setAccessible(true);
                Map credentials = (Map)credentialField.get(subversionDescriptor);
                SubversionSCM.DescriptorImpl.Credential cred = (SubversionSCM.DescriptorImpl.Credential)credentials.get(realm);
                if (cred == null) {
                    LOGGER.severe("No credentials are stored in Hudson for realm <" + realm + "> !");
                    return null;
                }
                String kind = "";
                return this.createSCMCredentialConfiguration(cred.createSVNAuthentication(kind));
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, "'credentials' field not readable on SubversionSCM.DescriptorImpl !");
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.SEVERE, "'credentials' field not readable on SubversionSCM.DescriptorImpl !");
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "'credentials' field not accessible on " + String.valueOf(subversionDescriptor) + " !");
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "'credentials' field not accessible on " + String.valueOf(subversionDescriptor) + " !");
            }
            catch (SVNException e) {
                LOGGER.log(Level.WARNING, "Error creating SVN authentication from realm <" + realm + "> !", e);
            }
        }
        return null;
    }

    private String retrieveRealmFor(String scmURL) {
        SVNRepository repository;
        String[] realms = new String[]{null};
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)scmURL));
            repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
        }
        catch (SVNException e) {
            LOGGER.throwing(SVNRepositoryFactory.class.getName(), "create", e);
            LOGGER.severe("Error while creating SVNRepository : " + e.getMessage());
            return null;
        }
        try {
            repository.setAuthenticationManager((ISVNAuthenticationManager)new /* Unavailable Anonymous Inner Class!! */);
            repository.testConnection();
        }
        catch (SVNException e) {
            // empty catch block
        }
        return realms[0];
    }

    public SCMCredentialConfiguration createSCMCredentialConfiguration(SVNAuthentication auth) {
        if (auth instanceof SVNPasswordAuthentication) {
            SVNPasswordAuthentication passAuth = (SVNPasswordAuthentication)auth;
            return new SCMCredentialConfiguration(passAuth.getUserName(), passAuth.getPassword());
        }
        if (auth instanceof SVNSSHAuthentication) {
            SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
            return new SCMCredentialConfiguration(sshAuth.getUserName(), sshAuth.getPassword(), sshAuth.getPassphrase(), sshAuth.getPrivateKey());
        }
        if (auth instanceof SVNSSLAuthentication) {
            SVNSSLAuthentication sslAuth = (SVNSSLAuthentication)auth;
            return new SCMCredentialConfiguration(sslAuth.getUserName(), sslAuth.getPassword());
        }
        if (auth instanceof SVNUserNameAuthentication) {
            SVNUserNameAuthentication unameAuth = (SVNUserNameAuthentication)auth;
            return new SCMCredentialConfiguration(unameAuth.getUserName());
        }
        return null;
    }
}

