/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies;

import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.model.ConfigurationEntityMatcher;
import hudson.plugins.scm_sync_configuration.strategies.model.PageMatcher;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScmSyncStrategy
implements ScmSyncStrategy {
    private ConfigurationEntityMatcher configEntityMatcher;
    private List<PageMatcher> pageMatchers;

    protected AbstractScmSyncStrategy(ConfigurationEntityMatcher _configEntityMatcher, List<PageMatcher> _pageMatchers) {
        this.configEntityMatcher = _configEntityMatcher;
        this.pageMatchers = _pageMatchers;
    }

    public boolean isSaveableApplicable(Saveable saveable, File file) {
        return this.configEntityMatcher.matches(saveable, file);
    }

    public PageMatcher getPageMatcherMatching(String url) {
        String rootUrl = Hudson.getInstance().getRootUrl();
        String cleanedUrl = null;
        cleanedUrl = url.startsWith(rootUrl) ? url.substring(rootUrl.length()) : url;
        for (PageMatcher pm : this.pageMatchers) {
            if (!pm.getUrlRegex().matcher(cleanedUrl).matches()) continue;
            return pm;
        }
        return null;
    }

    public boolean isCurrentUrlApplicable(String url) {
        return this.getPageMatcherMatching(url) != null;
    }
}

