/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.extensions;

import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationPlugin;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import java.io.File;

public class ScmSyncConfigurationItemListener
extends ItemListener {
    public void onLoaded() {
        super.onLoaded();
        ScmSyncConfigurationPlugin.getInstance().init();
    }

    public void onDeleted(Item item) {
        super.onDeleted(item);
        ScmSyncConfigurationPlugin plugin = ScmSyncConfigurationPlugin.getInstance();
        ScmSyncStrategy strategy = plugin.getStrategyForSaveable((Saveable)item, null);
        if (strategy != null) {
            plugin.deleteHierarchy(item.getRootDir());
        }
    }

    public void onCreated(Item item) {
        super.onCreated(item);
    }

    public void onCopied(Item src, Item item) {
        super.onCopied(src, item);
    }

    public void onRenamed(Item item, String oldName, String newName) {
        super.onRenamed(item, oldName, newName);
        ScmSyncConfigurationPlugin plugin = ScmSyncConfigurationPlugin.getInstance();
        ScmSyncStrategy strategy = plugin.getStrategyForSaveable((Saveable)item, null);
        if (strategy != null) {
            File parentDir = item.getRootDir().getParentFile();
            File oldDir = new File(parentDir.getAbsolutePath() + File.separator + oldName);
            File newDir = new File(parentDir.getAbsolutePath() + File.separator + newName);
            plugin.renameHierarchy(oldDir, newDir);
        }
    }
}

