/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.scms;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.scm_sync_configuration.scms.SCMCredentialConfiguration;
import hudson.plugins.scm_sync_configuration.scms.impl.ScmSyncNoSCM;
import hudson.plugins.scm_sync_configuration.scms.impl.ScmSyncSubversionSCM;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCM {
    protected static final Logger LOGGER = Logger.getLogger(SCM.class.getName());
    protected static final List<SCM> SCM_IMPLEMENTATIONS = new ArrayList<SCM>(){
        {
            this.add(new ScmSyncNoSCM());
            this.add(new ScmSyncSubversionSCM());
        }
    };
    protected transient String title;
    protected transient String scmClassName;
    protected transient String configPage;
    protected transient String repositoryUrlHelpPath;

    protected SCM(String _title, String _configPage, String _scmClassName, String _repositoryUrlHelpPath) {
        this.title = _title;
        this.configPage = _configPage;
        this.scmClassName = _scmClassName;
        this.repositoryUrlHelpPath = _repositoryUrlHelpPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getConfigPage() {
        return this.configPage;
    }

    public String getSCMClassName() {
        return this.scmClassName;
    }

    public Descriptor<? extends hudson.scm.SCM> getSCMDescriptor() {
        return Hudson.getInstance().getDescriptorByName(this.getSCMClassName());
    }

    public String getRepositoryUrlHelpPath() {
        return this.repositoryUrlHelpPath;
    }

    public ScmRepository getConfiguredRepository(ScmManager scmManager, String scmRepositoryURL) {
        ScmProviderRepositoryWithHost repositoryWithHost;
        SCMCredentialConfiguration credentials = this.extractScmCredentials(this.extractScmUrlFrom(scmRepositoryURL));
        if (credentials == null) {
            return null;
        }
        LOGGER.info("Creating SCM repository object for url : " + scmRepositoryURL);
        ScmRepository repository = null;
        try {
            repository = scmManager.makeScmRepository(scmRepositoryURL);
        }
        catch (ScmRepositoryException e) {
            LOGGER.throwing(ScmManager.class.getName(), "makeScmRepository", e);
            LOGGER.severe("Error creating ScmRepository : " + e.getMessage());
        }
        catch (NoSuchScmProviderException e) {
            LOGGER.throwing(ScmManager.class.getName(), "makeScmRepository", e);
            LOGGER.severe("Error creating ScmRepository : " + e.getMessage());
        }
        if (repository == null) {
            return null;
        }
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
            LOGGER.info("Populating host data into SCM repository object ...");
            repositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
            String host = repositoryWithHost.getHost();
            int port = repositoryWithHost.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
        }
        if (credentials != null) {
            LOGGER.info("Populating credentials data into SCM repository object ...");
            if (!StringUtils.isEmpty((String)credentials.getUsername())) {
                scmRepo.setUser(credentials.getUsername());
            }
            if (!StringUtils.isEmpty((String)credentials.getPassword())) {
                scmRepo.setPassword(credentials.getPassword());
            }
            if (scmRepo instanceof ScmProviderRepositoryWithHost) {
                repositoryWithHost = (ScmProviderRepositoryWithHost)scmRepo;
                if (!StringUtils.isEmpty((String)credentials.getPrivateKey())) {
                    repositoryWithHost.setPrivateKey(credentials.getPrivateKey());
                }
                if (!StringUtils.isEmpty((String)credentials.getPassphrase())) {
                    repositoryWithHost.setPassphrase(credentials.getPassphrase());
                }
            }
        }
        return repository;
    }

    public abstract String createScmUrlFromRequest(StaplerRequest var1);

    public abstract String extractScmUrlFrom(String var1);

    public abstract SCMCredentialConfiguration extractScmCredentials(String var1);

    public static SCM valueOf(String scmId) {
        for (SCM scm : SCM_IMPLEMENTATIONS) {
            if (!scmId.equals(scm.getId())) continue;
            return scm;
        }
        return null;
    }

    public static SCM[] values() {
        return SCM_IMPLEMENTATIONS.toArray(new SCM[0]);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("class", (Object)this.getClass().getName()).append("title", (Object)this.title).append("scmClassName", (Object)this.scmClassName).append("configPage", (Object)this.configPage).append("repositoryUrlHelpPath", (Object)this.repositoryUrlHelpPath).toString();
    }

    public String getId() {
        return this.getClass().getName();
    }

    public static class SCMXStreamConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return SCM.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            SCM scm = (SCM)source;
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String id = reader.getAttribute("class");
            if (SCM.class.getName().equals(id)) {
                id = ScmSyncSubversionSCM.class.getName();
            }
            return SCM.valueOf(id);
        }
    }
}

