/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies.model;

import hudson.model.Saveable;
import hudson.plugins.scm_sync_configuration.HudsonFilesHelper;
import hudson.plugins.scm_sync_configuration.strategies.model.ConfigurationEntityMatcher;
import java.io.File;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAndFileConfigurationEntityMatcher
implements ConfigurationEntityMatcher {
    private Class<? extends Saveable> saveableClazz;
    private Pattern filePathRegex;

    public ClassAndFileConfigurationEntityMatcher(Class<? extends Saveable> clazz, String _filePathRegex) {
        this.saveableClazz = clazz;
        this.filePathRegex = Pattern.compile(_filePathRegex);
    }

    @Override
    public boolean matches(Saveable saveable, File file) {
        if (this.saveableClazz.isAssignableFrom(saveable.getClass())) {
            if (file == null) {
                return true;
            }
            String filePathRelativeToHudsonRoot = HudsonFilesHelper.buildPathRelativeToHudsonRoot(file);
            return this.filePathRegex.matcher(filePathRelativeToHudsonRoot).matches();
        }
        return false;
    }
}

